/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.network;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.ServerboundPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public abstract class NetworkHandler {
    private final String modId;

    public NetworkHandler(String modId) {
        this.modId = modId;
    }

    public final void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.modId);
        this.onRegister(registrar);
    }

    public abstract void onRegister(PayloadRegistrar var1);

    protected static <T extends ClientboundPacket> void clientbound(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playToClient(type, codec, ClientboundPacket::handleOnClient);
    }

    protected static <T extends ServerboundPacket> void serverbound(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playToServer(type, codec, ServerboundPacket::handleOnServer);
    }

    protected static <T extends ServerboundPacket & ClientboundPacket> void bidirectional(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playBidirectional(type, codec, (payload, context) -> {
            if (context.flow().isClientbound()) {
                ((ClientboundPacket)payload).handleOnClient(context);
            } else if (context.flow().isServerbound()) {
                payload.handleOnServer(context);
            }
        });
    }
}

