/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.network.serverPacket;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.ae2addonlib.api.SettingsRegistry;

public record AddonConfigButtonPacket(String modId, Setting<?> option, boolean backwards) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AddonConfigButtonPacket> STREAM_CODEC = StreamCodec.ofMember(AddonConfigButtonPacket::write, AddonConfigButtonPacket::decode);
    public static final CustomPacketPayload.Type<AddonConfigButtonPacket> TYPE = CustomAppEngPayload.createType((String)"ae2lib_config_button");

    public CustomPacketPayload.Type<AddonConfigButtonPacket> type() {
        return TYPE;
    }

    private static AddonConfigButtonPacket decode(RegistryFriendlyByteBuf stream) {
        String modId = stream.readUtf();
        Setting<?> option = SettingsRegistry.getOrThrow(modId, stream.readUtf());
        boolean rotationDirection = stream.readBoolean();
        return new AddonConfigButtonPacket(modId, option, rotationDirection);
    }

    private void write(RegistryFriendlyByteBuf data) {
        data.writeUtf(this.modId);
        data.writeUtf(this.option.getName());
        data.writeBoolean(this.backwards);
    }

    public void handleOnServer(ServerPlayer player) {
        AEBaseMenu baseMenu;
        Object object;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)abstractContainerMenu).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                AELog.info((String)"Ignoring unsupported setting %s sent by client on %s", (Object[])new Object[]{this.option, baseMenu.getTarget()});
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        Enum currentValue = cm.getSetting(setting);
        Enum nextValue = EnumCycler.rotateEnum((Enum)currentValue, (boolean)this.backwards, (Set)setting.getValues());
        cm.putSetting(setting, nextValue);
    }
}

