/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.AEBaseItem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.ae2addonlib.registry.BlockRegistry;
import net.pedroksl.ae2addonlib.registry.FluidRegistry;
import net.pedroksl.ae2addonlib.registry.ItemRegistry;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import net.pedroksl.ae2addonlib.registry.helpers.ICreativeTabItem;
import org.slf4j.Logger;

public class CreativeTabRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<CreativeModeTab>> DRMap = new HashMap<String, DeferredRegister<CreativeModeTab>>();
    private final String modId;

    public CreativeTabRegistry(String modId, Component title, Supplier<ItemStack> icon) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize CreativeTabRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DeferredRegister dr = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)modId);
        dr.register("tab", () -> CreativeModeTab.builder().title(title).icon(icon).displayItems((p, o) -> CreativeTabRegistry.populateTab(modId, p, o)).build());
        DRMap.put(modId, (DeferredRegister<CreativeModeTab>)dr);
    }

    static DeferredRegister<CreativeModeTab> getDR(String modId) {
        DeferredRegister dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    private static void populateTab(String modId, CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        ArrayList<Object> itemDefs = new ArrayList<Object>();
        itemDefs.addAll(ItemRegistry.getItems(modId));
        itemDefs.addAll(BlockRegistry.getBlocks(modId).stream().map(BlockDefinition::item).toList());
        itemDefs.addAll(FluidRegistry.getFluids(modId).stream().map(FluidDefinition::bucketItemId).toList());
        for (ItemDefinition itemDefinition : itemDefs) {
            AEBaseBlockItem baseItem;
            Block block;
            Item item = itemDefinition.asItem();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)item).getBlock()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(params, output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)item;
                baseItem2.addToMainCreativeTab(params, output);
                continue;
            }
            if (item instanceof ICreativeTabItem) {
                ICreativeTabItem creativeTabItem = (ICreativeTabItem)item;
                creativeTabItem.addToMainCreativeTab(params, output);
                continue;
            }
            output.accept((ItemLike)itemDefinition);
        }
    }

    public void register(IEventBus eventBus) {
        CreativeTabRegistry.getDR(this.modId).register(eventBus);
    }
}

