/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public class ItemRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister.Items> DRMap = new HashMap<String, DeferredRegister.Items>();
    private static final Map<String, List<ItemDefinition<?>>> ITEMS = new HashMap();
    private final String modId;

    public ItemRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize AddonItems on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, DeferredRegister.createItems((String)modId));
        ITEMS.put(modId, new ArrayList());
    }

    static DeferredRegister.Items getDR(String modId) {
        DeferredRegister.Items dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    public List<ItemDefinition<?>> getItems() {
        return ItemRegistry.getItems(this.modId);
    }

    public static List<ItemDefinition<?>> getItems(String modId) {
        return Collections.unmodifiableList(ITEMS.getOrDefault(modId, new ArrayList()));
    }

    protected static <T extends Item> ItemDefinition<T> item(String modId, String englishName, String id, Function<Item.Properties, T> factory) {
        ItemDefinition definition = new ItemDefinition(englishName, ItemRegistry.getDR(modId).registerItem(id, factory));
        ITEMS.get(modId).add(definition);
        return definition;
    }

    protected static <T extends IPart> ItemDefinition<PartItem<T>> part(String modId, String englishName, String id, Class<T> partClass, Function<IPartItem<T>, T> factory) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        return ItemRegistry.item(modId, englishName, id, p -> new PartItem(p, partClass, factory));
    }

    public void register(IEventBus eventBus) {
        ItemRegistry.getDR(this.modId).register(eventBus);
    }
}

