/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.RealmsAvailability;
import com.mojang.realmsclient.dto.RealmsNotification;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.task.DataFetcher;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RealmsNotificationsScreen
extends RealmsScreen {
    private static final ResourceLocation UNSEEN_NOTIFICATION_SPRITE = ResourceLocation.withDefaultNamespace("icon/unseen_notification");
    private static final ResourceLocation NEWS_SPRITE = ResourceLocation.withDefaultNamespace("icon/news");
    private static final ResourceLocation INVITE_SPRITE = ResourceLocation.withDefaultNamespace("icon/invite");
    private static final ResourceLocation TRIAL_AVAILABLE_SPRITE = ResourceLocation.withDefaultNamespace("icon/trial_available");
    private final CompletableFuture<Boolean> validClient = RealmsAvailability.get().thenApply(p_293571_ -> p_293571_.type() == RealmsAvailability.Type.SUCCESS);
    @Nullable
    private DataFetcher.Subscription realmsDataSubscription;
    @Nullable
    private DataFetcherConfiguration currentConfiguration;
    private volatile int numberOfPendingInvites;
    private static boolean trialAvailable;
    private static boolean hasUnreadNews;
    private static boolean hasUnseenNotifications;
    private final DataFetcherConfiguration showAll = new DataFetcherConfiguration(){

        @Override
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher p_294752_) {
            DataFetcher.Subscription datafetcher$subscription = p_294752_.dataFetcher.createSubscription();
            RealmsNotificationsScreen.this.addNewsAndInvitesSubscriptions(p_294752_, datafetcher$subscription);
            RealmsNotificationsScreen.this.addNotificationsSubscriptions(p_294752_, datafetcher$subscription);
            return datafetcher$subscription;
        }

        @Override
        public boolean showOldNotifications() {
            return true;
        }
    };
    private final DataFetcherConfiguration onlyNotifications = new DataFetcherConfiguration(){

        @Override
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher p_275318_) {
            DataFetcher.Subscription datafetcher$subscription = p_275318_.dataFetcher.createSubscription();
            RealmsNotificationsScreen.this.addNotificationsSubscriptions(p_275318_, datafetcher$subscription);
            return datafetcher$subscription;
        }

        @Override
        public boolean showOldNotifications() {
            return false;
        }
    };

    public RealmsNotificationsScreen() {
        super(GameNarrator.NO_TITLE);
    }

    public void init() {
        if (this.realmsDataSubscription != null) {
            this.realmsDataSubscription.forceUpdate();
        }
    }

    public void added() {
        super.added();
        this.minecraft.realmsDataFetcher().notificationsTask.reset();
    }

    @Nullable
    private DataFetcherConfiguration getConfiguration() {
        boolean flag;
        boolean bl = flag = this.inTitleScreen() && this.validClient.getNow(false) != false;
        if (!flag) {
            return null;
        }
        return this.getRealmsNotificationsEnabled() ? this.showAll : this.onlyNotifications;
    }

    public void tick() {
        DataFetcherConfiguration realmsnotificationsscreen$datafetcherconfiguration = this.getConfiguration();
        if (!Objects.equals(this.currentConfiguration, realmsnotificationsscreen$datafetcherconfiguration)) {
            this.currentConfiguration = realmsnotificationsscreen$datafetcherconfiguration;
            this.realmsDataSubscription = this.currentConfiguration != null ? this.currentConfiguration.initDataFetcher(this.minecraft.realmsDataFetcher()) : null;
        }
        if (this.realmsDataSubscription != null) {
            this.realmsDataSubscription.tick();
        }
    }

    private boolean getRealmsNotificationsEnabled() {
        return (Boolean)this.minecraft.options.realmsNotifications().get();
    }

    private boolean inTitleScreen() {
        return this.minecraft.screen instanceof TitleScreen;
    }

    public void render(GuiGraphics p_282587_, int p_282992_, int p_283028_, float p_281605_) {
        super.render(p_282587_, p_282992_, p_283028_, p_281605_);
        if (this.validClient.getNow(false).booleanValue()) {
            this.drawIcons(p_282587_);
        }
    }

    public void renderBackground(GuiGraphics p_294179_, int p_294689_, int p_294445_, float p_294874_) {
    }

    private void drawIcons(GuiGraphics p_282966_) {
        int i = this.numberOfPendingInvites;
        int j = 24;
        int k = this.height / 4 + (this.inTitleScreen() ? 32 : 48);
        int l = this.width / 2 + 100;
        int i1 = k + 48 + 2;
        int j1 = l - 3;
        if (hasUnseenNotifications) {
            p_282966_.blitSprite(UNSEEN_NOTIFICATION_SPRITE, j1 - 12, i1 + 3, 10, 10);
            j1 -= 16;
        }
        if (this.currentConfiguration != null && this.currentConfiguration.showOldNotifications()) {
            if (hasUnreadNews) {
                p_282966_.blitSprite(NEWS_SPRITE, j1 - 14, i1 + 1, 14, 14);
                j1 -= 16;
            }
            if (i != 0) {
                p_282966_.blitSprite(INVITE_SPRITE, j1 - 14, i1 + 1, 14, 14);
                j1 -= 16;
            }
            if (trialAvailable) {
                p_282966_.blitSprite(TRIAL_AVAILABLE_SPRITE, j1 - 10, i1 + 4, 8, 8);
            }
        }
    }

    void addNewsAndInvitesSubscriptions(RealmsDataFetcher p_275490_, DataFetcher.Subscription p_275623_) {
        p_275623_.subscribe(p_275490_.pendingInvitesTask, p_239521_ -> {
            this.numberOfPendingInvites = p_239521_;
        });
        p_275623_.subscribe(p_275490_.trialAvailabilityTask, p_239494_ -> {
            trialAvailable = p_239494_;
        });
        p_275623_.subscribe(p_275490_.newsTask, p_238946_ -> {
            p_275490_.newsManager.updateUnreadNews(p_238946_);
            hasUnreadNews = p_275490_.newsManager.hasUnreadNews();
        });
    }

    void addNotificationsSubscriptions(RealmsDataFetcher p_275619_, DataFetcher.Subscription p_275628_) {
        p_275628_.subscribe(p_275619_.notificationsTask, p_274637_ -> {
            hasUnseenNotifications = false;
            for (RealmsNotification realmsnotification : p_274637_) {
                if (realmsnotification.seen()) continue;
                hasUnseenNotifications = true;
                break;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface DataFetcherConfiguration {
        public DataFetcher.Subscription initDataFetcher(RealmsDataFetcher var1);

        public boolean showOldNotifications();
    }
}

