/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LatchBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final BooleanProperty INPUT_A = PlateBlockStateProperties.INPUT_A;
    public static final BooleanProperty INPUT_C = PlateBlockStateProperties.INPUT_C;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final InputSide[] INPUT_SIDES = new InputSide[]{InputSide.A, InputSide.C};
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;

    public LatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState baseState = this.defaultBlockState();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)baseState.setValue((Property)INPUT_A, (Comparable)Boolean.valueOf(false))).setValue((Property)INPUT_C, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{INPUT_A, INPUT_C, POWERED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (((Boolean)state.getValue((Property)INPUT_C)).booleanValue()) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Deprecated
    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (((Boolean)state.getValue((Property)INPUT_A)).booleanValue() && ((Boolean)state.getValue((Property)INPUT_C)).booleanValue()) {
            return 0;
        }
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        Direction outputDirectionWhenPowered = PlateBlockStateProperties.getOutputDirection(state);
        return powered && sideOfAdjacentBlock == outputDirectionWhenPowered.getOpposite() || !powered && sideOfAdjacentBlock == outputDirectionWhenPowered ? 15 : 0;
    }

    public void tick(BlockState oldBlockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockState stateWithNewInput = InputState.getUpdatedBlockState((Level)level, oldBlockState, pos);
        InputState newInputState = InputState.getWorldPowerState((Level)level, stateWithNewInput, pos);
        boolean wasPowered = (Boolean)oldBlockState.getValue((Property)POWERED);
        boolean isPowered = wasPowered && !newInputState.c || !wasPowered && newInputState.a;
        BlockState newBlockState = (BlockState)stateWithNewInput.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (newBlockState != oldBlockState) {
            level.setBlock(pos, newBlockState, 2);
        }
    }

    @Override
    public InputSide[] getInputSides() {
        return INPUT_SIDES;
    }

    @Override
    public EnumSet<Direction> getOutputSides(Level level, BlockPos pos, BlockState state) {
        Direction primaryDirection = PlateBlockStateProperties.getOutputDirection(state);
        Direction oppositeDirection = primaryDirection.getOpposite();
        return EnumSet.of(primaryDirection, oppositeDirection);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return super.canConnectRedstone(state, world, pos, side) || side != null && side == PlateBlockStateProperties.getOutputDirection(state);
    }
}

