/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.LoadingCache;
import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.DefaultWireProperties;
import commoble.morered.api.internal.WireVoxelHelpers;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.BundledCableBlockEntity;
import commoble.morered.wires.Edge;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BundledCableBlock
extends AbstractWireBlock
implements EntityBlock {
    public static final VoxelShape[] NODE_SHAPES_DUNSWE = WireVoxelHelpers.makeNodeShapes(3, 4);
    public static final VoxelShape[] RAYTRACE_BACKBOARDS = WireVoxelHelpers.makeRaytraceBackboards(4);
    public static final VoxelShape[] LINE_SHAPES = WireVoxelHelpers.makeLineShapes(3, 4);
    public static final VoxelShape[] SHAPES_BY_STATE_INDEX = AbstractWireBlock.makeVoxelShapes(NODE_SHAPES_DUNSWE, LINE_SHAPES);
    public static final LoadingCache<Long, VoxelShape> VOXEL_CACHE = AbstractWireBlock.makeVoxelCache(SHAPES_BY_STATE_INDEX, LINE_SHAPES);

    public BundledCableBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPES_BY_STATE_INDEX, RAYTRACE_BACKBOARDS, VOXEL_CACHE, false);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().bundledNetworkCableBeType.get()).create(pos, state);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        long edgeFlags;
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Direction directionFromNeighbor = DirectionHelper.getDirectionToNeighborPos(neighbor, pos);
        if (directionFromNeighbor == null) {
            return;
        }
        ChanneledPowerSupplier neighborPowerSupplier = (ChanneledPowerSupplier)level.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, neighbor, (Object)directionFromNeighbor);
        if (neighborPowerSupplier != null) {
            this.updatePowerAfterBlockUpdate(level, pos, state);
        }
        if ((edgeFlags = this.getEdgeFlags((BlockGetter)world, pos)) != 0L) {
            EnumSet<Direction> edgeUpdateDirs = EnumSet.noneOf(Direction.class);
            Direction directionToNeighbor = directionFromNeighbor.getOpposite();
            Edge[] edges = Edge.values();
            for (int edgeFlag = 0; edgeFlag < 12; ++edgeFlag) {
                if ((edgeFlags & (long)(1 << edgeFlag)) == 0L) continue;
                Edge edge = edges[edgeFlag];
                if (edge.sideA == directionToNeighbor) {
                    edgeUpdateDirs.add(edge.sideB);
                    continue;
                }
                if (edge.sideB != directionToNeighbor) continue;
                edgeUpdateDirs.add(edge.sideA);
            }
            if (!edgeUpdateDirs.isEmpty()) {
                BlockPos.MutableBlockPos mutaPos = pos.mutable();
                for (Direction dir : edgeUpdateDirs) {
                    BlockPos.MutableBlockPos otherNeighborPos = mutaPos.setWithOffset((Vec3i)pos, dir);
                    world.getBlockState((BlockPos)otherNeighborPos).onNeighborChange(world, (BlockPos)otherNeighborPos, pos);
                }
            }
        }
    }

    @Override
    protected void updatePowerAfterBlockUpdate(Level world, BlockPos wirePos, BlockState wireState) {
        BlockEntity te = world.getBlockEntity(wirePos);
        if (!(te instanceof BundledCableBlockEntity)) {
            return;
        }
        BundledCableBlockEntity wire = (BundledCableBlockEntity)te;
        Map<Block, WireConnector> connectors = MoreRedAPI.getCableConnectabilityRegistry();
        WireConnector defaultConnector = MoreRedAPI.getDefaultCableConnector();
        BlockPos.MutableBlockPos mutaPos = wirePos.mutable();
        BlockState[] neighborStates = new BlockState[6];
        EnumMap<Direction, ChanneledPowerSupplier> neighborPowerSuppliers = new EnumMap<Direction, ChanneledPowerSupplier>(Direction.class);
        ChanneledPowerSupplier noPower = DefaultWireProperties.NO_POWER_SUPPLIER;
        Function<BlockPos, Function> neighborPowerFinder = neighborPos -> directionToNeighbor -> {
            ChanneledPowerSupplier neighborSupplier = (ChanneledPowerSupplier)world.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, neighborPos, (Object)directionToNeighbor.getOpposite());
            return neighborSupplier == null ? noPower : neighborSupplier;
        };
        for (int channel = 0; channel < 16; ++channel) {
            EnumSet<Direction> facesNeedingUpdates = EnumSet.noneOf(Direction.class);
            boolean[] attachedFaceStates = new boolean[6];
            for (int attachmentSide = 0; attachmentSide < 6; ++attachmentSide) {
                if (((Boolean)wireState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) {
                    attachedFaceStates[attachmentSide] = true;
                    facesNeedingUpdates.add(Direction.from3DDataValue((int)attachmentSide));
                    continue;
                }
                wire.setPower(attachmentSide, channel, 0);
            }
            int iteration = 0;
            while (!facesNeedingUpdates.isEmpty()) {
                ChanneledPowerSupplier attachedNeighborPowerSupplier;
                int attachmentSide;
                Direction attachmentDirection;
                if (!facesNeedingUpdates.remove(attachmentDirection = Direction.from3DDataValue((int)(attachmentSide = iteration++ % 6)))) continue;
                mutaPos.setWithOffset((Vec3i)wirePos, attachmentDirection);
                BlockState attachedNeighborState = neighborStates[attachmentSide];
                if (attachedNeighborState == null) {
                    neighborStates[attachmentSide] = attachedNeighborState = world.getBlockState((BlockPos)mutaPos);
                }
                if ((attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(attachmentDirection)) == null) {
                    attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(attachmentDirection);
                    neighborPowerSuppliers.put(attachmentDirection, attachedNeighborPowerSupplier);
                }
                int power = Math.max(0, attachedNeighborPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
                for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
                    BlockEntity diagonalTe;
                    Block neighborBlock;
                    WireConnector connector;
                    int neighborSide = DirectionHelper.uncompressSecondSide(attachmentSide, orthagonal);
                    Direction directionToNeighbor = Direction.from3DDataValue((int)neighborSide);
                    Direction directionToWire = directionToNeighbor.getOpposite();
                    BlockState neighborState = neighborStates[neighborSide];
                    mutaPos.setWithOffset((Vec3i)wirePos, directionToNeighbor);
                    if (neighborState == null) {
                        neighborStates[neighborSide] = neighborState = world.getBlockState((BlockPos)mutaPos);
                    }
                    if ((connector = connectors.getOrDefault(neighborBlock = neighborState.getBlock(), defaultConnector)).canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                        ChanneledPowerSupplier orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(directionToNeighbor);
                        if (orthagonalPowerSupplier == null) {
                            orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(directionToNeighbor);
                            neighborPowerSuppliers.put(directionToNeighbor, orthagonalPowerSupplier);
                        }
                        power = Math.max(power, orthagonalPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
                    }
                    if (directionToNeighbor != attachmentDirection) {
                        power = Math.max(power, wire.getPower(neighborSide, channel) - 1);
                    }
                    if (attachedFaceStates[neighborSide] || neighborBlock != this || ((Boolean)neighborState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) continue;
                    BlockPos.MutableBlockPos diagonalPos = mutaPos.move(attachmentDirection);
                    BlockState diagonalState = world.getBlockState((BlockPos)mutaPos);
                    int directionToWireSide = directionToWire.ordinal();
                    if (diagonalState.getBlock() != this || !((Boolean)diagonalState.getValue((Property)INTERIOR_FACES[directionToWireSide])).booleanValue() || !((diagonalTe = world.getBlockEntity((BlockPos)diagonalPos)) instanceof BundledCableBlockEntity)) continue;
                    power = Math.max(power, ((BundledCableBlockEntity)diagonalTe).getPower(directionToWireSide, channel) - 1);
                }
                if (!wire.setPower(attachmentSide, channel, power)) continue;
                Direction[] nextUpdateDirs = BlockStateUtil.OUTPUT_TABLE[attachmentSide];
                for (int i = 0; i < 4; ++i) {
                    Direction nextUpdateDir = nextUpdateDirs[i];
                    if (!attachedFaceStates[nextUpdateDir.ordinal()]) continue;
                    facesNeedingUpdates.add(nextUpdateDir);
                }
            }
        }
    }

    @Override
    protected void notifyNeighbors(Level world, BlockPos wirePos, BlockState newState, EnumSet<Direction> updateDirections, boolean doConductedPowerUpdates) {
    }

    @Override
    protected boolean canAdjacentBlockConnectToFace(BlockGetter world, BlockPos thisPos, BlockState thisState, Block neighborBlock, Direction attachmentDirection, Direction directionToWire, BlockPos neighborPos, BlockState neighborState) {
        return MoreRedAPI.getCableConnectabilityRegistry().getOrDefault(neighborBlock, MoreRedAPI.getDefaultCableConnector()).canConnectToAdjacentWire(world, neighborPos, neighborState, thisPos, thisState, attachmentDirection, directionToWire);
    }
}

