/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.mixin;

import com.respawningstructures.structure.RespawnManager;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GravityProcessor.class})
public class GravityProcessorMixin {
    @Shadow
    @Final
    private int offset;

    @Inject(method={"processBlock"}, at={@At(value="RETURN")}, cancellable=true)
    private void checkAndAdjustRespawn(LevelReader levelReader, BlockPos p_74110_, BlockPos p_74111_, StructureTemplate.StructureBlockInfo relativeInfo, StructureTemplate.StructureBlockInfo p_74113_, StructurePlaceSettings p_74114_, CallbackInfoReturnable<StructureTemplate.StructureBlockInfo> cir) {
        int y;
        int relativeY;
        StructureTemplate.StructureBlockInfo result = (StructureTemplate.StructureBlockInfo)cir.getReturnValue();
        if (result == null || RespawnManager.respawnInProgress == null || !Thread.currentThread().getName().toLowerCase().contains("server")) {
            return;
        }
        if (!result.state().isAir() && this.offset < 0) {
            boolean existsBelow = false;
            for (int i = 0; i < 7; ++i) {
                BlockState prevState = levelReader.getBlockState(result.pos().below(relativeInfo.pos().getY() + i));
                if (prevState.getBlock() != result.state().getBlock()) continue;
                existsBelow = true;
                break;
            }
            if (existsBelow) {
                int res;
                relativeY = relativeInfo.pos().getY();
                if (RespawnManager.heightMap != null && (res = RespawnManager.heightMap.getInt((Object)new BlockPos(relativeInfo.pos().getX(), 0, relativeInfo.pos().getZ()))) > 0) {
                    relativeY = res;
                }
                BlockPos fixedpos = new BlockPos(result.pos().getX(), Math.min(p_74111_.getY() + 10, Math.max(p_74110_.getY() - 10, result.pos().getY() - relativeY)), result.pos().getZ());
                if (result.state().is(BlockTags.CROPS)) {
                    if (levelReader.getBlockState(fixedpos.below()).is(BlockTags.CROPS)) {
                        // empty if block
                    }
                    if (!(levelReader.getBlockState(fixedpos.below()).is(Blocks.FARMLAND) || levelReader.getBlockState(fixedpos.below()).getBlock() instanceof FarmBlock || levelReader.getBlockState(fixedpos.below()).is(BlockTags.DIRT))) {
                        cir.setReturnValue(null);
                        return;
                    }
                }
                cir.setReturnValue((Object)new StructureTemplate.StructureBlockInfo(fixedpos, result.state(), result.nbt()));
            }
        }
        if (levelReader.getBlockState(((StructureTemplate.StructureBlockInfo)cir.getReturnValue()).pos().below()).is(BlockTags.LEAVES)) {
            cir.setReturnValue(null);
            return;
        }
        if (!result.state().is(BlockTags.CROPS) && levelReader.getBlockState(result.pos()).is(BlockTags.CROPS)) {
            cir.setReturnValue((Object)new StructureTemplate.StructureBlockInfo(result.pos().below(), result.state(), result.nbt()));
        }
        if ((y = result.pos().getY()) > p_74110_.getY() + 10 || y < p_74110_.getY() - 10) {
            int res;
            relativeY = relativeInfo.pos().getY();
            if (RespawnManager.heightMap != null && (res = RespawnManager.heightMap.getInt((Object)new BlockPos(relativeInfo.pos().getX(), 0, relativeInfo.pos().getZ()))) > 0) {
                relativeY = res;
            }
            BlockPos fixedpos = new BlockPos(result.pos().getX(), Math.min(p_74111_.getY() + 10, Math.max(p_74110_.getY() - 10, result.pos().getY() - relativeY)), result.pos().getZ());
            cir.setReturnValue((Object)new StructureTemplate.StructureBlockInfo(fixedpos, result.state(), result.nbt()));
        }
    }
}

