/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CompatConfig {
    private static final Map<ModConfig.Type, List<ConfigHandler>> CONFIGS = Arrays.stream(ModConfig.Type.values()).collect(Collectors.toMap(Function.identity(), k -> new ArrayList()));

    public static void addConfig(ModConfig.Type cfg, ConfigHandler b) {
        CONFIGS.get(cfg).add(b);
    }

    public static void build(ModConfig.Type cfg, ModConfigSpec.Builder builder) {
        CONFIGS.get(cfg).forEach(c -> c.build(builder));
    }

    public static void reload(ModConfig.Type type) {
        CONFIGS.get(type).forEach(ConfigHandler::reload);
    }

    public static interface ConfigHandler {
        public void build(ModConfigSpec.Builder var1);

        public void reload();
    }
}

