/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.byAqua3.avaritia.compat.emi.handler.RecipeHandlerCompressor;
import net.byAqua3.avaritia.compat.emi.handler.RecipeHandlerExtremeCrafting;
import net.byAqua3.avaritia.compat.emi.recipe.EMIRecipeCollector;
import net.byAqua3.avaritia.compat.emi.recipe.EMIRecipeCompressor;
import net.byAqua3.avaritia.compat.emi.recipe.EMIRecipeExtremeCrafting;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaMenus;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.util.RecipeUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class AvaritiaEMIPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory EXTREME_CRAFTING = new EmiRecipeCategory(ResourceLocation.tryBuild((String)"avaritia", (String)"extreme_crafting"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.EXTREME_CRAFTING_TABLE_ITEM.get())));
    public static final EmiRecipeCategory COMPRESSOR = new EmiRecipeCategory(ResourceLocation.tryBuild((String)"avaritia", (String)"compressor"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.COMPRESSOR_ITEM.get())));
    public static final EmiRecipeCategory COLLECTOR = new EmiRecipeCategory(ResourceLocation.tryBuild((String)"avaritia", (String)"collector"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.NEUTRON_COLLECTOR_ITEM.get())));

    public void registerCategories(EmiRegistry registry) {
        registry.addCategory(EXTREME_CRAFTING);
        registry.addCategory(COMPRESSOR);
        registry.addCategory(COLLECTOR);
    }

    public void registerRecipes(EmiRegistry registry) {
        RecipeManager recipeManager = registry.getRecipeManager();
        for (RecipeExtremeCrafting recipeExtremeCrafting : RecipeUtils.getExtremeCraftingRecipes(recipeManager)) {
            registry.addRecipe((EmiRecipe)new EMIRecipeExtremeCrafting(recipeManager, recipeExtremeCrafting));
        }
        for (RecipeCompressor recipeCompressor : RecipeUtils.getCompressorRecipes(recipeManager)) {
            registry.addRecipe((EmiRecipe)new EMIRecipeCompressor(recipeManager, recipeCompressor));
        }
        for (RecipeCollector recipeCollector : RecipeUtils.getCollectorRecipes()) {
            registry.addRecipe((EmiRecipe)new EMIRecipeCollector(recipeManager, recipeCollector));
        }
    }

    public void registerWorkstations(EmiRegistry registry) {
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.COMPRESSED_CRAFTING_TABLE_ITEM.get())));
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get())));
        registry.addWorkstation(EXTREME_CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.EXTREME_CRAFTING_TABLE_ITEM.get())));
        registry.addWorkstation(COMPRESSOR, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.COMPRESSOR_ITEM.get())));
        registry.addWorkstation(COLLECTOR, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AvaritiaBlocks.NEUTRON_COLLECTOR_ITEM.get())));
    }

    public void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler((MenuType)AvaritiaMenus.EXTREME_CRAFTING.get(), (EmiRecipeHandler)new RecipeHandlerExtremeCrafting());
        registry.addRecipeHandler((MenuType)AvaritiaMenus.COMPRESSOR.get(), (EmiRecipeHandler)new RecipeHandlerCompressor());
    }

    public void registerDefaultComparisons(EmiRegistry registry) {
        registry.setDefaultComparison(AvaritiaItems.JSON_SINGULARITY.get(), Comparison.of((stack1, stack2) -> ItemStack.isSameItemSameComponents((ItemStack)stack1.getItemStack(), (ItemStack)stack2.getItemStack())));
    }

    public void removeEmiStacks(EmiRegistry registry) {
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)AvaritiaItems.MATTER_CLUSTER.get())));
    }

    public void register(EmiRegistry registry) {
        this.registerCategories(registry);
        this.registerRecipes(registry);
        this.registerWorkstations(registry);
        this.registerRecipeHandlers(registry);
        this.registerDefaultComparisons(registry);
        this.removeEmiStacks(registry);
    }
}

