/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaTiers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ItemInfinityPickaxe
extends PickaxeItem {
    public ItemInfinityPickaxe(Item.Properties properties) {
        super((Tier)AvaritiaTiers.INFINITY, properties.attributes(PickaxeItem.createAttributes((Tier)AvaritiaTiers.INFINITY, (float)15.0f, (float)-2.8f)));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        stack.enchant(Minecraft.getInstance().level.registryAccess().holderOrThrow(Enchantments.FORTUNE), 10);
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        int blockRange = (int)Math.round(8.0);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.has((DataComponentType)AvaritiaDataComponents.HAMMER.get()) && ((Boolean)stack.getOrDefault((DataComponentType)AvaritiaDataComponents.HAMMER.get(), (Object)false)).booleanValue()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int x = -blockRange; x <= blockRange; ++x) {
                    for (int y = -blockRange; y <= blockRange; ++y) {
                        for (int z = -blockRange; z <= blockRange; ++z) {
                            BlockPos rangePos = new BlockPos(Mth.floor((float)(pos.getX() + x)), Mth.floor((float)(pos.getY() + y)), Mth.floor((float)(pos.getZ() + z)));
                            BlockState rangeState = level.getBlockState(rangePos);
                            Block rangeBlock = rangeState.getBlock();
                            if (rangeState.isAir()) continue;
                            if (!level.isClientSide() && !player.isCreative()) {
                                LootParams.Builder lootParams$builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)rangePos)).withParameter(LootContextParams.TOOL, (Object)stack).withOptionalParameter(LootContextParams.BLOCK_ENTITY, null);
                                List blockDrops = rangeState.getDrops(lootParams$builder);
                                if (!blockDrops.isEmpty()) {
                                    drops.addAll(blockDrops);
                                } else {
                                    ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)rangeBlock);
                                    Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
                                    drops.add(new ItemStack((ItemLike)blockItem));
                                }
                            }
                            if (!(rangeBlock instanceof BaseFireBlock)) {
                                level.levelEvent(2001, rangePos, Block.getId((BlockState)rangeState));
                            }
                            level.setBlockAndUpdate(rangePos, Blocks.AIR.defaultBlockState());
                            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, rangePos, GameEvent.Context.of((Entity)player, (BlockState)rangeState));
                        }
                    }
                }
                if (!level.isClientSide() && !drops.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ItemMatterCluster.makeCluster(drops));
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, livingEntity);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null && stack.has((DataComponentType)AvaritiaDataComponents.HAMMER.get()) && ((Boolean)stack.getOrDefault((DataComponentType)AvaritiaDataComponents.HAMMER.get(), (Object)false)).booleanValue()) {
            int i = 10;
            entity.setDeltaMovement(entity.getDeltaMovement().add(-Math.sin(attacker.getYRot() * (float)Math.PI / 180.0f) * (double)i * 0.5, 2.0, Math.cos(attacker.getYRot() * (float)Math.PI / 180.0f) * (double)i * 0.5));
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                stack.update((DataComponentType)AvaritiaDataComponents.HAMMER.get(), (Object)false, hammer -> hammer == false);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

