/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.capabilities.modular;

import net.minecraft.world.item.Rarity;
import tv.soaryn.xycraft.api.content.capabilities.modular.ModuleRarities;

public enum ModuleType {
    Base(0xAAAAAA, (Rarity)ModuleRarities.Base.getValue(), otherModule -> true),
    Legendary(0x99AACC, (Rarity)ModuleRarities.Legendary.getValue(), otherModule -> true),
    Specialization(0xBBAA66, (Rarity)ModuleRarities.Specialized.getValue(), ModuleType::isUnspecialized),
    Mythic(0x8866AA, (Rarity)ModuleRarities.Mythic.getValue(), otherModule -> false);

    private final Rarity _rarity;
    public final int SubTextColor;
    private final ICompatibleCheck _check;

    private ModuleType(int subTextColor, Rarity rarity, ICompatibleCheck check) {
        this.SubTextColor = subTextColor;
        this._rarity = rarity;
        this._check = check;
    }

    public Rarity getRarity() {
        return this._rarity;
    }

    public boolean isCompatible(ModuleType type) {
        return this._check.test(type);
    }

    public static boolean isUnspecialized(ModuleType moduleType) {
        return moduleType != Specialization;
    }

    @FunctionalInterface
    public static interface ICompatibleCheck {
        public boolean test(ModuleType var1);
    }
}

