/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.xynergy;

import java.text.DecimalFormat;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNet;

public class XynergyNet {
    private static final DecimalFormat formatter = new DecimalFormat("#0.##");
    public static Function<ServerLevel, IXynergyNet> Net = level -> null;
    public static final long XynergyUnit = 1000L;

    private XynergyNet() {
    }

    public static long xynergyUnit(long value) {
        return 1000L * value;
    }

    public static String valueToString(long value) {
        if (value >= 1000000000000000000L) {
            return "Infinity";
        }
        if (value <= -1000000000000000000L) {
            return "-Infinity";
        }
        return formatter.format((double)value / 1000.0);
    }

    public static IXynergyNet of(ServerLevel level) {
        return Net.apply(level);
    }

    public static long xynergyOf(ServerLevel level, BlockPos pos) {
        IXynergyNet net = XynergyNet.of(level);
        if (net == null) {
            return -1L;
        }
        return net.getEnergy(pos);
    }

    public static boolean hasXynergy(ServerLevel level, BlockPos pos) {
        return XynergyNet.hasXynergy(level, pos, 0L);
    }

    public static boolean hasXynergy(ServerLevel level, BlockPos pos, long value) {
        IXynergyNet net = XynergyNet.of(level);
        if (net != null && net.hasNode(pos)) {
            return net.getEnergy(pos) >= value;
        }
        return false;
    }

    public static void setNet(Function<ServerLevel, IXynergyNet> net) {
        Net = net;
    }

    static {
        formatter.setGroupingSize(3);
        formatter.setGroupingUsed(true);
    }
}

