/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.resource;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ResourceStack;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public final class MutableResourceStack<T extends IResource> {
    private final T resource;
    private int amount;

    public static <TResource extends IResource> NonNullList<MutableResourceStack<TResource>> nonNullListOfSize(int count, MutableResourceStack<TResource> resourceStack) {
        return NonNullList.withSize((int)count, resourceStack);
    }

    public NonNullList<MutableResourceStack<T>> nonNullListOfSize(int count) {
        return MutableResourceStack.nonNullListOfSize(count, this);
    }

    private MutableResourceStack(T resource, int amount) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        this.amount = amount;
    }

    public static <T extends IResource> MutableResourceStack<T> of(ResourceStack<T> stack) {
        return MutableResourceStack.of(stack.resource(), stack.amount());
    }

    public static <T extends IResource> MutableResourceStack<T> of(T resource, int amount) {
        return new MutableResourceStack<T>(resource, amount);
    }

    public static <B extends FriendlyByteBuf, T extends IResource> StreamCodec<B, MutableResourceStack<T>> streamCodec(StreamCodec<? super B, T> resourceCodec) {
        return StreamCodec.composite(resourceCodec, MutableResourceStack::resource, (StreamCodec)ByteBufCodecs.VAR_INT, MutableResourceStack::amount, MutableResourceStack::new);
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.resource.isEmpty();
    }

    public MutableResourceStack<T> withAmount(int newAmount) {
        this.amount = newAmount;
        return this;
    }

    public MutableResourceStack<T> shrink(int amount) {
        return this.withAmount(Math.max(this.amount - amount, 0));
    }

    public MutableResourceStack<T> grow(int amount) {
        return this.withAmount(this.amount + amount);
    }

    public MutableResourceStack<T> with(UnaryOperator<T> operator) {
        return new MutableResourceStack<IResource>((IResource)operator.apply(this.resource), this.amount);
    }

    public T resource() {
        return this.resource;
    }

    public int amount() {
        return this.amount;
    }

    public boolean isSameResource(MutableResourceStack<T> other) {
        return this.resource.equals(other.resource);
    }

    public boolean isSameResource(T other) {
        return this.resource.equals(other);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MutableResourceStack that = (MutableResourceStack)obj;
        return Objects.equals(this.resource, that.resource) && this.amount == that.amount;
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.amount);
    }

    public String toString() {
        return "MutableResourceStack[resource=%s, amount=%d]".formatted(this.resource, this.amount);
    }

    public ResourceStack<T> immutable() {
        return new ResourceStack<T>(this.resource, this.amount);
    }

    public static final class Codecs {
        public static final Codec<MutableResourceStack<FluidResource>> OPTIONAL_FLUID_CODEC = CodecUtils.Codecs.FLUID_STACK_OPTIONAL.xmap(fluidStack -> MutableResourceStack.of(FluidResource.of(fluidStack), fluidStack.getAmount()), stack -> ((FluidResource)stack.resource()).toStack(stack.amount()));
        public static final Codec<MutableResourceStack<ItemResource>> OPTIONAL_ITEM_CODEC = CodecUtils.Codecs.ITEM_STACK_OPTIONAL.xmap(stack -> MutableResourceStack.of(ItemResource.of(stack), stack.getCount()), stack -> ((ItemResource)stack.resource()).toStack(stack.amount()));

        private Codecs() {
        }
    }

    public static final class Empty {
        public static final MutableResourceStack<FluidResource> FLUID = MutableResourceStack.of(FluidResource.EMPTY_STACK);
        public static final MutableResourceStack<ItemResource> ITEM = MutableResourceStack.of(ItemResource.EMPTY_STACK);

        private Empty() {
        }
    }
}

