/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class DrawableButton
extends DrawableWidget<DrawableButton> {
    private final Reference2ObjectMap<ButtonLayer, ResourceLocation> textureMap = new Reference2ObjectOpenHashMap();
    private final Reference2BooleanMap<ButtonLayer> renderMap = new Reference2BooleanOpenHashMap();
    private final Reference2IntMap<ButtonLayer> colorMap = new Reference2IntOpenHashMap();

    private DrawableButton() {
    }

    public DrawableButton setLayer(ButtonLayer layer, boolean value) {
        this.renderMap.put((Object)layer, value);
        return this;
    }

    public boolean getLayer(ButtonLayer layer) {
        return this.renderMap.getOrDefault((Object)layer, false);
    }

    public DrawableButton setColor(ButtonLayer layer, int value) {
        this.colorMap.put((Object)layer, value);
        return this;
    }

    public static DrawableButton create() {
        DrawableButton button = new DrawableButton();
        button.textureMap.put((Object)ButtonLayer.Base, (Object)XyCore.resource("textures/gui/button_base.png"));
        button.textureMap.put((Object)ButtonLayer.Active, (Object)XyCore.resource("textures/gui/button_active.png"));
        button.textureMap.put((Object)ButtonLayer.Hovered, (Object)XyCore.resource("textures/gui/button_hover.png"));
        button.renderMap.put((Object)ButtonLayer.Base, true);
        button.renderMap.put((Object)ButtonLayer.Active, false);
        button.renderMap.put((Object)ButtonLayer.Hovered, false);
        button.colorMap.put((Object)ButtonLayer.Base, -1);
        button.colorMap.put((Object)ButtonLayer.Active, -1);
        button.colorMap.put((Object)ButtonLayer.Hovered, -1);
        return button;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        boolean contains = this.contains(mouseX, mouseY);
        this.renderMap.put((Object)ButtonLayer.Hovered, contains);
        RenderSystem.enableBlend();
        for (ButtonLayer value : ButtonLayer.values()) {
            if (!this.renderMap.getOrDefault((Object)value, false)) continue;
            ResourceLocation location = (ResourceLocation)this.textureMap.get((Object)value);
            int color = this.colorMap.getInt((Object)value);
            Vector4f rgba = ColorUtils.convertToRGBAVec(color);
            graphics.setColor(rgba.x, rgba.y, rgba.z, rgba.w);
            RenderSystem._setShaderTexture((int)0, (ResourceLocation)location);
            TiledIcon.innerBlit(graphics, x + this.Dimensions.x, x + this.Dimensions.x + this.Dimensions.width, y + this.Dimensions.y, y + this.Dimensions.y + this.Dimensions.height, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static enum ButtonLayer {
        Base,
        Active,
        Hovered;

    }
}

