/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.config.CoreClientConfig;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.resources.FluidUtils;

public class DrawableFluid
extends DrawableWidget<DrawableFluid> {
    private final TextureAtlas _textureAtlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
    private IFluidHandler _fluidHandler;
    private int _tankIndex;
    private boolean _showCapacity = true;
    private boolean _showMarkers = true;
    private static final DecimalFormat _format = new DecimalFormat(",##0.###");

    private DrawableFluid() {
    }

    public static DrawableFluid create() {
        return new DrawableFluid();
    }

    public DrawableFluid tank(IFluidHandler handler, int index) {
        this._fluidHandler = handler;
        this._tankIndex = index;
        return this;
    }

    public DrawableFluid fluid(FluidStack fluid) {
        FluidTank tank = new FluidTank(fluid.getAmount());
        tank.setFluid(fluid);
        this._fluidHandler = tank;
        return this;
    }

    public DrawableFluid showCapacity(boolean value) {
        this._showCapacity = value;
        return this;
    }

    public DrawableFluid showMarkers(boolean value) {
        this._showMarkers = value;
        return this;
    }

    @Override
    public void appendToolTips(double mouseX, double mouseY, List<Component> tooltip) {
        if (this.Visible && this.contains(mouseX, mouseY)) {
            FluidStack fluid = this._fluidHandler.getFluidInTank(this._tankIndex);
            boolean showAdded = Screen.hasShiftDown() || ModifierKey.of(Utils.getClientPlayer());
            MutableComponent component = Component.empty();
            if (!fluid.isEmpty()) {
                component.append((Component)fluid.getHoverName().plainCopy().append(": ").withStyle(Style.EMPTY.withColor(0xFFCC66)));
                this.formatFluidAmount(showAdded, component, fluid.getAmount());
            } else {
                component.append((Component)Component.translatable((String)"gui.xycraft_machines.tank.empty"));
            }
            tooltip.add((Component)component);
            int capacity = this._fluidHandler.getTankCapacity(this._tankIndex);
            if (!this._showCapacity) {
                return;
            }
            MutableComponent capacityComponent = Component.translatable((String)"gui.xycraft_machines.tank.capacity").append(": ").withStyle(Style.EMPTY.withColor(0x77BBFF));
            this.formatFluidAmount(showAdded, capacityComponent, capacity);
            tooltip.add((Component)capacityComponent);
        }
        super.appendToolTips(mouseX, mouseY, tooltip);
    }

    private void formatFluidAmount(boolean showAdded, MutableComponent component, int amount) {
        CoreClientConfig.MeasuringUnit unit = (CoreClientConfig.MeasuringUnit)((Object)XyCore.ClientConfig.FluidUnit.get());
        component.append((Component)(amount >= 1000 && !showAdded ? Component.literal((String)String.format("%s %s", _format.format((double)amount / 1000.0), unit.Unit)).withStyle(ChatFormatting.GRAY) : Component.literal((String)String.format("%s %s", _format.format(amount), unit.MilliUnit)).withStyle(ChatFormatting.GRAY)));
    }

    @Override
    protected void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        if (this._fluidHandler == null) {
            return;
        }
        FluidStack fluid = this._fluidHandler.getFluidInTank(this._tankIndex);
        int capacity = this._fluidHandler.getTankCapacity(this._tankIndex);
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        int color = fluidInfo.getTintColor(fluid);
        Vector4f rgb = ColorUtils.convertToRGBAVec(color);
        TextureAtlasSprite sprite = fluid.isEmpty() ? null : this._textureAtlas.getSprite(fluidInfo.getStillTexture(fluid));
        RenderSystem.enableBlend();
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._textureAtlas.location());
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        if (!fluid.isEmpty()) {
            float fluidHeight = (float)fluid.getAmount() / (float)capacity;
            if (FluidUtils.isGas(fluid)) {
                rgb.w = Math.max((float)fluid.getAmount() / (float)capacity, 0.05f);
                if (rgb.w < 0.999f) {
                    RenderSystem.enableBlend();
                }
                fluidHeight = 1.0f;
            }
            fluidHeight = Math.max(fluidHeight, 0.05f);
            graphics.setColor(rgb.x(), rgb.y(), rgb.z(), rgb.w());
            if (sprite != null) {
                TiledIcon.render(poseStack, x + this.Dimensions.x, y + this.Dimensions.y, this.Dimensions.width, fluidHeight * this.Dimensions.height, 1.25f, sprite, new TiledIcon.TileConfiguration(false, this.Dimensions.width, this.Dimensions.height));
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this._showMarkers) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)XyCore.resource("textures/gui/tank_markers.png"));
            TiledIcon.innerBlit(poseStack.last().pose(), x + this.Dimensions.x, x + this.Dimensions.x + this.Dimensions.width, y + this.Dimensions.y, y + this.Dimensions.y + this.Dimensions.height, 0.0f, 0.0f, 1.0f, 0.0f, this.Dimensions.height / 16.0f);
        }
        poseStack.popPose();
    }
}

