/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class InjectBlock {
    @Unique
    private static boolean isValidBiome(Holder<Biome> biome) {
        Optional key = biome.unwrapKey();
        return key.map(biomeRegistryKey -> !((List)ParticularConfig.COMMON.caveDustExcludeBiomes.get()).contains(biomeRegistryKey.location())).orElse(true);
    }

    @Inject(at={@At(value="TAIL")}, method={"animateTick"})
    public void spawnParticles(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        Block block = state.getBlock();
        if (ParticularConfig.fireflies()) {
            double val = random.nextDouble();
            if (block == Blocks.GRASS_BLOCK && val < (Double)ParticularConfig.COMMON.fireflyGrassFrequency.get() || block == Blocks.TALL_GRASS && val < (Double)ParticularConfig.COMMON.fireflyTallGrassFrequency.get() || block instanceof FlowerBlock && val < (Double)ParticularConfig.COMMON.fireflyFlowersFrequency.get() || block instanceof TallFlowerBlock && val < (Double)ParticularConfig.COMMON.fireflyTallFlowersFrequency.get()) {
                Main.spawnFirefly(world, pos, random);
                return;
            }
        }
        if (ParticularConfig.caveDust() && (block == Blocks.AIR || block == Blocks.CAVE_AIR) && random.nextInt(((Integer)ParticularConfig.COMMON.caveDustSpawnChance.get()).intValue()) == 0 && pos.getY() < world.getSeaLevel() && InjectBlock.isValidBiome((Holder<Biome>)world.getBiome(pos))) {
            float lightChance = 1.0f - (float)Math.min(8, world.getBrightness(LightLayer.SKY, pos)) / 8.0f;
            float depthChance = Math.min(1.0f, (float)(world.getSeaLevel() - pos.getY()) / 96.0f);
            if (random.nextFloat() < lightChance * depthChance) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble();
                double z = (double)pos.getZ() + random.nextDouble();
                world.addParticle((ParticleOptions)Particles.CAVE_DUST.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

