/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.pop;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import pro.mikey.mods.pop.client.pops.AnimTracker;
import pro.mikey.mods.pop.client.pops.FadeInFadeOutRender;
import pro.mikey.mods.pop.client.pops.PopManager;
import pro.mikey.mods.pop.data.Placement;
import pro.mikey.mods.pop.data.PopData;
import pro.mikey.mods.pop.net.ClientCreatePopPacket;

public class PopBuilder {
    private static final Component DEFAULT_CONTENT = Component.literal((String)"Hello from PopBuilder!");
    private int durationInSeconds = 5;
    private Component content = DEFAULT_CONTENT;
    private Placement placement = Placement.MIDDLE_CENTER;

    private PopBuilder() {
    }

    public static PopBuilder create() {
        return new PopBuilder();
    }

    public PopBuilder duration(int durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    public PopBuilder content(Component content) {
        this.content = content;
        return this;
    }

    public PopBuilder placement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public PopBuilder placement(String placement) {
        return this.placementByString(placement);
    }

    public PopBuilder placementByString(String placement) {
        this.placement = Placement.fromString(placement);
        return this;
    }

    public void sendToPlayer(Player player) {
        if (player.level().isClientSide()) {
            throw new IllegalStateException("This method should only be called on the server side");
        }
        ClientCreatePopPacket packet = new ClientCreatePopPacket(this.content, this.placement, this.durationInSeconds);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void display() {
        PopManager.get().addPop(this.build());
    }

    public PopData build() {
        return new PopData(this.content, this.placement, new FadeInFadeOutRender(), new AnimTracker(this.durationInSeconds * 1000));
    }
}

