/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.pop.client.pops;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import pro.mikey.mods.pop.client.pops.IPopRender;
import pro.mikey.mods.pop.data.AnimStage;
import pro.mikey.mods.pop.data.PopData;

public class FadeInFadeOutRender
implements IPopRender {
    float lastOpacity = 0.0f;

    @Override
    public void render(PopData pop, GuiGraphics graphics, DeltaTracker deltaTracker) {
        pop.tracker().onRenderFrame();
        AnimStage stage = pop.tracker().getStage();
        int currentStageCompletion = pop.tracker().currentStageCompletion();
        float delta = deltaTracker.getGameTimeDeltaTicks();
        float opacity = 1.0f;
        float xOffset = 0.0f;
        if (stage != AnimStage.IDLE) {
            float nextOpacity;
            this.lastOpacity = nextOpacity = stage == AnimStage.IN ? (float)currentStageCompletion / 100.0f : 1.0f - (float)currentStageCompletion / 100.0f;
            opacity = Mth.lerp((float)delta, (float)this.lastOpacity, (float)nextOpacity);
        }
        PoseStack pose = graphics.pose();
        pose.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        int textWidth = Minecraft.getInstance().font.width((FormattedText)pop.content());
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int[] location = pop.placement().location(screenWidth, screenHeight, textWidth);
        int x = location[0];
        int y = location[1];
        graphics.drawString(Minecraft.getInstance().font, pop.content(), x, (int)((float)y + xOffset), 0xFFFFFF);
        pose.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

