/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity.dispenser;

import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final HashMap<Item, DispenseItemBehavior> DISPENSE_ITEM_BEHAVIOR_HASH_MAP = new HashMap();
    public static final CuttingBoardDispenseBehavior INSTANCE = new CuttingBoardDispenseBehavior();

    public static void registerBehaviour(Item item, CuttingBoardDispenseBehavior behavior) {
        DISPENSE_ITEM_BEHAVIOR_HASH_MAP.put(item, (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(item));
        DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behavior);
    }

    public final ItemStack dispense(BlockSource source, ItemStack stack) {
        if (this.tryDispenseStackOnCuttingBoard(source, stack)) {
            this.playSound(source);
            this.playAnimation(source, (Direction)source.state().getValue((Property)DispenserBlock.FACING));
            return stack;
        }
        return DISPENSE_ITEM_BEHAVIOR_HASH_MAP.get(stack.getItem()).dispense(source, stack);
    }

    public boolean tryDispenseStackOnCuttingBoard(BlockSource source, ItemStack stack) {
        this.setSuccess(false);
        ServerLevel level = source.level();
        BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (block instanceof CuttingBoardBlock && blockEntity instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity cuttingBoard = (CuttingBoardBlockEntity)blockEntity;
            ItemStack boardItem = cuttingBoard.getStoredItem().copy();
            if (!boardItem.isEmpty() && cuttingBoard.processStoredItemUsingTool(stack, null)) {
                CuttingBoardBlock.spawnCuttingParticles((Level)level, pos, boardItem, 5);
                this.setSuccess(true);
            }
            return true;
        }
        return false;
    }
}

