/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render;

import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.block.tile.IdentificationChamberBlockEntity;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class IdentificationChamberRenderer
implements BlockEntityRenderer<IdentificationChamberBlockEntity> {
    private static RenderType LINES = IdentificationChamberRenderer.createRenderType();

    public static RenderType createRenderType() {
        RenderType.CompositeState.CompositeStateBuilder comp = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeLinesShader)).setDepthTestState(new RenderStateShard.DepthTestStateShard("always", 515)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(5.0))).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).setOutputState(new RenderStateShard.OutputStateShard("item_entity_target", () -> {
            if (Minecraft.useShaderTransparency()) {
                Minecraft.getInstance().levelRenderer.getItemEntityTarget().bindWrite(false);
            }
        }, () -> {
            if (Minecraft.useShaderTransparency()) {
                Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
            }
        })).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).setCullState(new RenderStateShard.CullStateShard(false));
        return RenderType.create((String)"lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)comp.createCompositeState(true));
    }

    public void render(IdentificationChamberBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)entity.getBlockState().getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (facing == Direction.EAST) {
            poseStack.translate(1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.translate(0.5f, 0.375f, 0.5f);
        float scale = 0.4f;
        ItemStack stack = entity.getInput().getStackInSlot(0);
        if (!stack.isEmpty()) {
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
            if (model.isGui3d()) {
                scale = 0.75f;
            }
            poseStack.pushPose();
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, multiBufferSource, entity.getLevel(), 0);
            poseStack.popPose();
        }
        poseStack.translate(-0.5f, -0.375f, -0.5f);
        float progress = ((float)entity.getProgress() + partialTicks / 100.0f) / (float)ReplicationConfig.IdentificationChamber.MAX_PROGRESS;
        poseStack.translate(0.0f, -0.2f, 0.0f);
        poseStack.translate(0.0f, -0.58f, 0.0f);
        poseStack.translate(0.0f, 0.58f * progress, 0.0f);
        VertexConsumer builder = multiBufferSource.getBuffer(LINES);
        if (entity.getProgress() > 0) {
            poseStack.pushPose();
            float reduction = 0.31f;
            poseStack.translate((double)reduction / 2.0, 0.0, (double)reduction / 2.0);
            poseStack.scale(1.0f - reduction, 1.0f, 1.0f - reduction);
            float alpha = (float)((double)0.8f + entity.getLevel().random.nextDouble() / 30.0);
            for (float i = 0.0f; i <= 1.01f; i += 0.1f) {
                IdentificationChamberRenderer.drawLine(poseStack, builder, 0.0f + i, 0.0f, 1.0f, 0.0f + i, ReplicationRegistry.Colors.GREEN_SPLIT[0], ReplicationRegistry.Colors.GREEN_SPLIT[1], ReplicationRegistry.Colors.GREEN_SPLIT[2], alpha);
                IdentificationChamberRenderer.drawLine(poseStack, builder, 0.0f, 0.0f + i, 0.0f + i, 1.0f, ReplicationRegistry.Colors.GREEN_SPLIT[0], ReplicationRegistry.Colors.GREEN_SPLIT[1], ReplicationRegistry.Colors.GREEN_SPLIT[2], alpha);
            }
            poseStack.popPose();
        }
    }

    private static void drawLine(PoseStack matrixStackIn, VertexConsumer bufferIn, float xIn, float zIn, float xTo, float zTo, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStackIn.last().pose();
        bufferIn.addVertex(matrix4f, xIn, 1.0f, zIn).setColor(red, green, blue, alpha);
        bufferIn.addVertex(matrix4f, zTo, 1.0f, xTo).setColor(red, green, blue, alpha);
    }
}

