/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.gtceu;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GTCEUCompatibility
implements IPlacer {
    public static Class<? extends Block> getBlockToRegister() {
        return PipeBlock.class;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> adjacentDirectionSides, ItemStack heldPipeItem) {
        if (!GeneralUtils.isVoidableBlock(level, pos)) {
            BlockState state = level.getBlockState(pos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)heldPipeItem);
                for (ItemStack drop : drops) {
                    if (player.getInventory().add(drop)) continue;
                    player.drop(drop, false);
                }
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.05);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            level.removeBlock(pos, false);
        }
        if (item instanceof PipeBlockItem) {
            BlockState blockState = Block.byItem((Item)item).defaultBlockState();
            boolean superVal = level.setBlock(pos, blockState, 11);
            if (superVal && !level.isClientSide) {
                PipeBlockItem pipeBlockItem = (PipeBlockItem)item;
                IPipeNode selfTile = pipeBlockItem.getBlock().getPipeTile((BlockGetter)level, pos);
                if (selfTile == null) {
                    return true;
                }
                for (Direction side : adjacentDirectionSides) {
                    if (!selfTile.getPipeBlock().canConnect(selfTile, side)) continue;
                    selfTile.setConnection(side, true, false);
                }
                for (Iterator<Object> iterator : GTUtil.DIRECTIONS) {
                    BlockEntity te = selfTile.getNeighbor(iterator);
                    if (te instanceof IPipeNode) {
                        IPipeNode otherPipe = (IPipeNode)te;
                        if (!otherPipe.isConnected(iterator.getOpposite())) continue;
                        if (otherPipe.getPipeBlock().canPipesConnect(otherPipe, iterator.getOpposite(), selfTile)) {
                            selfTile.setConnection(iterator, true, true);
                            continue;
                        }
                        otherPipe.setConnection(iterator.getOpposite(), false, true);
                        continue;
                    }
                    if (ConfigHolder.INSTANCE.machines.gt6StylePipesCables || !selfTile.getPipeBlock().canPipeConnectToBlock(selfTile, iterator, te)) continue;
                    selfTile.setConnection(iterator, true, false);
                }
                selfTile.notifyBlockUpdate();
            }
            return superVal;
        }
        return false;
    }
}

