/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import org.jetbrains.annotations.NotNull;

public class GuiDialogBase
extends GuiManipulable {
    private boolean blockOutsideClicks = false;
    private boolean closeOnOutsideClick = false;

    public GuiDialogBase(@NotNull GuiParent<?> rootAccess) {
        super((GuiParent)rootAccess.getModularGui().getRoot());
    }

    public GuiDialogBase setBlockOutsideClicks(boolean blockOutsideClicks) {
        this.blockOutsideClicks = blockOutsideClicks;
        return this;
    }

    public GuiDialogBase setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.closeOnOutsideClick && !this.getContentElement().getRectangle().contains(mouseX, mouseY)) {
            this.close();
        }
        return super.mouseClicked(mouseX, mouseY, button, consumed) || this.blockOutsideClicks;
    }

    public void close() {
        this.getParent().removeChild((GuiElement)this);
    }

    public GuiDialogBase setNormalizedPos(double x, double y) {
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> Math.min(Math.max(x, 0.0), (double)this.scaledScreenWidth() - this.xSize())));
        this.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> Math.min(Math.max(y, 0.0), (double)this.scaledScreenHeight() - this.ySize())));
        this.resetBounds();
        return this;
    }

    public GuiDialogBase placeCenter() {
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> ((double)this.scaledScreenWidth() - this.xSize()) / 2.0));
        this.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> ((double)this.scaledScreenHeight() - this.ySize()) / 2.0));
        this.resetBounds();
        return this;
    }
}

