/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown;

import java.awt.Point;

public class LayoutHelper {
    private final int xPos;
    private final int yPos;
    private final int width;
    private int caretX;
    private int caretY;
    private int currentLineHeight;

    public LayoutHelper(int xPos, int yPos, int width) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.caretX = xPos;
        this.caretY = yPos;
        this.currentLineHeight = 0;
    }

    public Point nextElementPos(int elementWidth, int elementHeight) {
        if (this.getCaretXOffset() + elementWidth > this.width && this.getCaretXOffset() > 0) {
            this.caretX = this.xPos;
            this.caretY += this.currentLineHeight;
            this.currentLineHeight = 0;
        }
        Point pos = new Point(this.caretX, this.caretY);
        this.caretX += elementWidth;
        this.currentLineHeight = Math.max(this.currentLineHeight, elementHeight);
        return pos;
    }

    public int getContainerHeight() {
        return this.caretY + this.currentLineHeight - this.yPos;
    }

    public void newLine(int minLineHeight) {
        this.currentLineHeight = Math.max(this.currentLineHeight, minLineHeight);
        this.caretX = this.xPos;
        this.caretY += this.currentLineHeight;
        this.currentLineHeight = 0;
    }

    public void newLine(int minLineHeight, int nextLineOffset) {
        this.currentLineHeight = Math.max(this.currentLineHeight, minLineHeight);
        this.currentLineHeight += nextLineOffset;
        this.caretX = this.xPos;
        this.caretY += this.currentLineHeight;
        this.currentLineHeight = 0;
    }

    public int getCaretXOffset() {
        return this.caretX - this.xPos;
    }

    public int getWidth() {
        return this.width;
    }

    public void addCaretOffset(int xOffset) {
        this.caretX += xOffset;
    }

    public int getCaretX() {
        return this.caretX;
    }

    public int getCaretY() {
        return this.caretY;
    }
}

