/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryDynamic
implements Container {
    private List<ItemStack> stacks = new LinkedList<ItemStack>();
    public int xp = 0;
    public static final Codec<InventoryDynamic> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)ItemStack.CODEC).fieldOf("stacks").forGetter(e -> e.stacks), (App)Codec.INT.fieldOf("xp").forGetter(e -> e.xp)).apply((Applicative)builder, InventoryDynamic::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryDynamic> STREAM_CODEC = BCStreamCodec.composite(ItemStack.LIST_STREAM_CODEC, e -> e.stacks, ByteBufCodecs.INT, e -> e.xp, InventoryDynamic::new);

    public InventoryDynamic() {
    }

    public InventoryDynamic(List<ItemStack> stacks, int xp) {
        this.stacks = stacks;
        this.xp = xp;
    }

    public InventoryDynamic copy() {
        return new InventoryDynamic(FastStream.of(this.stacks).map(ItemStack::copy).toList(), this.xp);
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 0) {
            return;
        }
        if (stack.isEmpty()) {
            if (index < this.stacks.size()) {
                this.stacks.remove(index);
            }
        } else if (index < this.stacks.size()) {
            this.stacks.set(index, stack);
        } else {
            this.stacks.add(stack);
        }
    }

    public int getContainerSize() {
        return this.stacks.size() + 1;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public ItemStack getItem(int index) {
        return index >= 0 && index < this.stacks.size() ? this.stacks.get(index) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = this.getItem(index);
        if (!itemstack.isEmpty()) {
            if (itemstack.getCount() <= count) {
                this.setItem(index, ItemStack.EMPTY);
            } else if ((itemstack = itemstack.split(count)).getCount() == 0) {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            this.setItem(index, ItemStack.EMPTY);
        }
        return stack;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.stacks.removeIf(ItemStack::isEmpty);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag compound) {
        ListTag list = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty() || stack.getCount() <= 0) continue;
            CompoundTag tag = new CompoundTag();
            list.add((Object)stack.save(provider, (Tag)tag));
        }
        compound.put("InvItems", (Tag)list);
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        ListTag list = compound.getList("InvItems", 10);
        this.stacks.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i)));
        }
    }

    public void removeIf(Predicate<ItemStack> filter) {
        this.stacks.removeIf(filter);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public void setStacks(LinkedList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InventoryDynamic)) {
            return false;
        }
        InventoryDynamic that = (InventoryDynamic)o;
        return this.xp == that.xp && Objects.equals(this.stacks, that.stacks);
    }

    public int hashCode() {
        return Objects.hash(this.stacks, this.xp);
    }
}

