/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEntryType;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.rhino.Context;
import java.util.Arrays;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class REIIntegration {
    @Nullable
    public static EntryType<?> typeOf(RecipeViewerEntryType type) {
        if (type == RecipeViewerEntryType.ITEM) {
            return VanillaEntryTypes.ITEM;
        }
        if (type == RecipeViewerEntryType.FLUID) {
            return VanillaEntryTypes.FLUID;
        }
        return null;
    }

    public static EntryStack<?> stackOf(Context cx, RecipeViewerEntryType type, Object from) {
        if (type == RecipeViewerEntryType.ITEM) {
            ItemStack in = (ItemStack)type.wrapEntry(cx, from);
            return EntryStacks.of((ItemStack)in);
        }
        if (type == RecipeViewerEntryType.FLUID) {
            net.neoforged.neoforge.fluids.FluidStack in = (net.neoforged.neoforge.fluids.FluidStack)type.wrapEntry(cx, from);
            return EntryStacks.of((FluidStack)FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)in));
        }
        ((KubeJSContext)cx).getConsole().error("Currently custom type '" + type.id + "' isn't supported");
        return EntryStack.empty();
    }

    public static EntryIngredient fluidIngredient(FluidIngredient ingredient) {
        return EntryIngredient.of(Arrays.stream(ingredient.getStacks()).map(FluidStackHooksForge::fromForge).map(EntryStacks::of).toList());
    }

    public static EntryIngredient ingredientOf(Context cx, RecipeViewerEntryType type, Object from) {
        if (type == RecipeViewerEntryType.ITEM) {
            EntryIngredient entryIngredient;
            ItemPredicate in = (ItemPredicate)type.wrapPredicate(cx, from);
            if (in instanceof Ingredient) {
                Ingredient i = (Ingredient)in;
                entryIngredient = EntryIngredients.ofIngredient((Ingredient)i);
            } else {
                entryIngredient = EntryIngredients.ofItemStacks(Arrays.asList(in.kjs$getStackArray()));
            }
            return entryIngredient;
        }
        if (type == RecipeViewerEntryType.FLUID) {
            return REIIntegration.fluidIngredient((FluidIngredient)type.wrapPredicate(cx, from));
        }
        ((KubeJSContext)cx).getConsole().error("Currently custom type '" + type.id + "' isn't supported");
        return EntryIngredient.empty();
    }
}

