/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.util.TickDuration;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface TimeJS {
    public static final Pattern TEMPORAL_AMOUNT_PATTERN = Pattern.compile("(\\d+)\\s*(y|M|d|w|h|m|s|ms|ns|t)\\b");

    public static TemporalAmount wrapTemporalAmount(Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TemporalAmount.class, Number.class, CharSequence.class}, (Object)object, n)) {
            case 0 -> {
                TemporalAmount d;
                yield d = (TemporalAmount)object;
            }
            case 1 -> {
                Number n = (Number)object;
                yield Duration.ofMillis(n.longValue());
            }
            case 2 -> {
                CharSequence cs = (CharSequence)object;
                Matcher matcher = TEMPORAL_AMOUNT_PATTERN.matcher(cs.toString());
                double millis = 0.0;
                double nanos = 0.0;
                double ticks = Double.NaN;
                block29: while (matcher.find()) {
                    double amount = Double.parseDouble(matcher.group(1));
                    switch (matcher.group(2)) {
                        case "t": {
                            if (Double.isNaN(ticks)) {
                                ticks = 0.0;
                            }
                            ticks += amount;
                            continue block29;
                        }
                        case "ns": {
                            nanos += amount;
                            continue block29;
                        }
                        case "ms": {
                            millis += amount;
                            continue block29;
                        }
                        case "s": {
                            millis = amount * 1000.0;
                            continue block29;
                        }
                        case "m": {
                            millis = amount * 60000.0;
                            continue block29;
                        }
                        case "h": {
                            millis = amount * 60000.0 * 60.0;
                            continue block29;
                        }
                        case "d": {
                            millis = amount * 86400.0 * 1000.0;
                            continue block29;
                        }
                        case "w": {
                            millis = amount * 86400.0 * 7000.0;
                            continue block29;
                        }
                        case "M": {
                            millis = amount * 3.1556952E7 / 12.0 * 1000.0;
                            continue block29;
                        }
                        case "y": {
                            millis = amount * 3.1556952E7 * 1000.0;
                            continue block29;
                        }
                    }
                    throw new IllegalArgumentException("Invalid temporal unit: " + matcher.group(2));
                }
                if (!Double.isNaN(ticks)) {
                    yield TickDuration.of((long)(ticks + millis / 50.0));
                }
                yield Duration.ofMillis((long)millis).plusNanos((long)nanos);
            }
            default -> throw new IllegalArgumentException("Invalid temporal amount: " + String.valueOf(o));
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Duration wrapDuration(Object o) {
        Duration duration;
        TemporalAmount t;
        TemporalAmount temporalAmount = t = TimeJS.wrapTemporalAmount(o);
        Objects.requireNonNull(temporalAmount);
        TemporalAmount temporalAmount2 = temporalAmount;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Duration.class, TickDuration.class}, (Object)temporalAmount2, n)) {
            case 0: {
                Duration d;
                duration = d = (Duration)temporalAmount2;
                return duration;
            }
            case 1: {
                long ticks;
                TickDuration tickDuration = (TickDuration)temporalAmount2;
                try {
                    long l;
                    ticks = l = tickDuration.ticks();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                duration = Duration.ofMillis(ticks * 50L);
                return duration;
            }
        }
        Duration d = Duration.ZERO;
        Iterator<TemporalUnit> iterator = t.getUnits().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                duration = d;
                return duration;
            }
            TemporalUnit unit = iterator.next();
            d = d.plus(t.get(unit), unit);
        }
    }

    public static void appendTimestamp(StringBuilder builder, Calendar calendar) {
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        if (h < 10) {
            builder.append('0');
        }
        builder.append(h);
        builder.append(':');
        if (m < 10) {
            builder.append('0');
        }
        builder.append(m);
        builder.append(':');
        if (s < 10) {
            builder.append('0');
        }
        builder.append(s);
    }

    public static String msToString(long ms) {
        if (ms < 1000L) {
            return ms + " ms";
        }
        return "%.3f".formatted(Float.valueOf((float)ms / 1000.0f)) + " s";
    }
}

