/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEntitySpawner
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BlockEntitySpawner(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityMGUSpawner(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? TileEntityMGUSpawner::clientTick : TileEntityMGUSpawner::serverTick;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    @Nonnull
    public InteractionResult useWithoutItem(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        BlockEntity tileentity;
        if (!world.isClientSide && (tileentity = world.getBlockEntity(pos)) instanceof TileEntityMGUSpawner) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)tileentity;
            player.openMenu((MenuProvider)tile, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TileEntityMGUSpawner tile;
        if (!world.isClientSide && !player.getAbilities().instabuild && (tile = (TileEntityMGUSpawner)world.getBlockEntity(pos)) != null) {
            if (!tile.inputSlots.getStackInSlot(0).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(0));
            }
            if (!tile.inputSlots.getStackInSlot(1).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(1));
            }
            if (!tile.inputSlots.getStackInSlot(2).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(2));
            }
            if (!tile.inputSlots.getStackInSlot(3).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(3));
            }
            if (!tile.fuelSlot.getStackInSlot(0).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.fuelSlot.getStackInSlot(0));
            }
            world.removeBlockEntity(pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)world.getBlockEntity(pos);
            if (tile != null) {
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void neighborChanged(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (!world.isClientSide) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)world.getBlockEntity(pos);
            boolean flag = (Boolean)state.getValue((Property)POWERED);
            if (flag != world.hasNeighborSignal(pos)) {
                if (flag) {
                    world.scheduleTick(pos, (Block)this, 4);
                } else {
                    world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                    if (tile != null) {
                        tile.isOn = (Boolean)state.getValue((Property)POWERED) == false;
                    }
                }
            }
        }
    }

    public void tick(@Nonnull BlockState state, ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (!world.isClientSide) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)world.getBlockEntity(pos);
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
                world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                if (tile != null) {
                    tile.isOn = (Boolean)state.getValue((Property)POWERED) == false;
                }
            }
        }
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return state.is((Block)ModBlocks.ENTITY_SPAWNER.getBlock());
    }
}

