/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelBuilder
extends ModelBuilder<ItemModelBuilder> {
    protected List<OverrideBuilder> overrides = new ArrayList<OverrideBuilder>();

    public ItemModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.GENERATED_TRIM_MODELS) {
            ArrayList trimNames = new ArrayList(trim.overrideArmorMaterials().values());
            trimNames.add(trim.name());
            for (String trimName : trimNames) {
                this.existingFileHelper.trackGenerated(ResourceLocation.withDefaultNamespace((String)("trims/items/boots_trim_" + trimName)), ModelProvider.TEXTURE);
                this.existingFileHelper.trackGenerated(ResourceLocation.withDefaultNamespace((String)("trims/items/chestplate_trim_" + trimName)), ModelProvider.TEXTURE);
                this.existingFileHelper.trackGenerated(ResourceLocation.withDefaultNamespace((String)("trims/items/helmet_trim_" + trimName)), ModelProvider.TEXTURE);
                this.existingFileHelper.trackGenerated(ResourceLocation.withDefaultNamespace((String)("trims/items/leggings_trim_" + trimName)), ModelProvider.TEXTURE);
            }
        }
    }

    public OverrideBuilder override() {
        OverrideBuilder ret = new OverrideBuilder();
        this.overrides.add(ret);
        return ret;
    }

    public OverrideBuilder override(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.overrides.size(), (String)"override");
        return this.overrides.get(index);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = super.toJson();
        if (!this.overrides.isEmpty()) {
            JsonArray overridesJson = new JsonArray();
            this.overrides.stream().map(OverrideBuilder::toJson).forEach(arg_0 -> ((JsonArray)overridesJson).add(arg_0));
            root.add("overrides", (JsonElement)overridesJson);
        }
        return root;
    }

    public class OverrideBuilder {
        private ModelFile model;
        private final Map<ResourceLocation, Float> predicates = new LinkedHashMap<ResourceLocation, Float>();

        public OverrideBuilder model(ModelFile model) {
            this.model = model;
            model.assertExistence();
            return this;
        }

        public OverrideBuilder predicate(ResourceLocation key, float value) {
            this.predicates.put(key, Float.valueOf(value));
            return this;
        }

        public ItemModelBuilder end() {
            return ItemModelBuilder.this;
        }

        JsonObject toJson() {
            JsonObject ret = new JsonObject();
            JsonObject predicatesJson = new JsonObject();
            this.predicates.forEach((key, val) -> predicatesJson.addProperty(key.toString(), (Number)val));
            ret.add("predicate", (JsonElement)predicatesJson);
            ret.addProperty("model", this.model.getLocation().toString());
            return ret;
        }
    }
}

