/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.ui.render.AdvancementPlaque;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.services.Services;
import com.google.common.collect.Queues;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;

public class ToastComponentWrapper
extends ToastComponent {
    private final AdvancementPlaque[] plaques = new AdvancementPlaque[1];
    private final Deque<AdvancementToast> advancementToastsQueue = Queues.newArrayDeque();
    private final Minecraft mc;
    private final CustomItemRenderer itemRenderer;
    private final ToastComponent wrapped;
    private final ReentrantLock wrapLock = new ReentrantLock(true);

    public ToastComponentWrapper(Minecraft mcIn, ToastComponent wrapped) {
        super(mcIn);
        this.mc = mcIn;
        this.wrapped = wrapped;
        this.itemRenderer = new CustomItemRenderer(this.mc.getTextureManager(), this.mc.getModelManager(), this.mc.itemColors, this.mc.getItemRenderer().blockEntityRenderer, this.mc);
    }

    public <T extends Toast> T getToast(Class<? extends T> class_, Object object) {
        this.wrapLock.lock();
        Toast toast = this.wrapped.getToast(class_, object);
        this.wrapLock.unlock();
        return (T)toast;
    }

    public void addToast(Toast toastIn) {
        if (toastIn instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toastIn;
            if (AdvancementPlaquesConfig.showPlaqueForAdvancement(advancementToast.advancement)) {
                this.advancementToastsQueue.add((AdvancementToast)toastIn);
                return;
            }
        }
        this.wrapLock.lock();
        this.wrapped.addToast(toastIn);
        this.wrapLock.unlock();
    }

    public void render(GuiGraphics graphics) {
        if (!this.mc.options.hideGui) {
            block12: {
                try {
                    this.wrapLock.lock();
                    this.wrapped.render(graphics);
                    this.wrapLock.unlock();
                    boolean wailaLoaded = Services.getPlatformHelper().isModLoaded("waila");
                    boolean jadeLoaded = Services.getPlatformHelper().isModLoaded("jade");
                    if (!AdvancementPlaquesConfig.getInstance().hideWaila.get().booleanValue() || !wailaLoaded && !jadeLoaded) break block12;
                    boolean anyPlaques = false;
                    for (int i = 0; i < this.plaques.length; ++i) {
                        if (this.plaques[i] == null) continue;
                        anyPlaques = true;
                        break;
                    }
                    if (anyPlaques) {
                        if (wailaLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("disableWaila", new Class[0]).invoke(null, new Object[0]);
                        }
                        if (jadeLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.JadeHandler").getMethod("disableJade", new Class[0]).invoke(null, new Object[0]);
                        }
                    } else {
                        if (wailaLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("enableWaila", new Class[0]).invoke(null, new Object[0]);
                        }
                        if (jadeLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.JadeHandler").getMethod("enableJade", new Class[0]).invoke(null, new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    AdvancementPlaques.LOGGER.error((Object)e);
                }
            }
            for (int i = 0; i < this.plaques.length; ++i) {
                AdvancementPlaque plaque = this.plaques[i];
                if (plaque != null && plaque.render(graphics.guiWidth(), i, graphics)) {
                    this.plaques[i] = null;
                }
                if (this.plaques[i] != null || this.advancementToastsQueue.isEmpty()) continue;
                this.plaques[i] = new AdvancementPlaque(this.advancementToastsQueue.removeFirst(), this.mc, this.itemRenderer);
            }
        }
    }

    public void clear() {
        this.wrapLock.lock();
        this.wrapped.clear();
        this.wrapLock.unlock();
        Arrays.fill(this.plaques, null);
        this.advancementToastsQueue.clear();
    }
}

