/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards;

import com.leclowndu93150.leaderboards.VanillaStatsRegistry;
import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.integration.FTBQuestsIntegration;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;

public class LeaderboardRegistry {
    public static final Map<ResourceLocation, Leaderboard> LEADERBOARDS = new LinkedHashMap<ResourceLocation, Leaderboard>();

    public static void register() {
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"deaths"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"deaths"), (Component)Component.translatable((String)"leaderboard.leaderboards.deaths"), Stats.CUSTOM.get((Object)Stats.DEATHS), false));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"mob_kills"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"mob_kills"), (Component)Component.translatable((String)"leaderboard.leaderboards.mob_kills"), Stats.CUSTOM.get((Object)Stats.MOB_KILLS), false));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"player_kills"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"player_kills"), (Component)Component.translatable((String)"leaderboard.leaderboards.player_kills"), Stats.CUSTOM.get((Object)Stats.PLAYER_KILLS), false));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_played"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"time_played"), (Component)Component.translatable((String)"leaderboard.leaderboards.time_played"), Stats.CUSTOM.get((Object)Stats.PLAY_TIME), false, Leaderboard.FromStat.TIME));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"jumps"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"jumps"), (Component)Component.translatable((String)"leaderboard.leaderboards.jumps"), Stats.CUSTOM.get((Object)Stats.JUMP), false));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"distance_walked"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"distance_walked"), (Component)Component.translatable((String)"leaderboard.leaderboards.distance_walked"), Stats.CUSTOM.get((Object)Stats.WALK_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"distance_sprinted"), new Leaderboard.FromStat(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"distance_sprinted"), (Component)Component.translatable((String)"leaderboard.leaderboards.distance_sprinted"), Stats.CUSTOM.get((Object)Stats.SPRINT_ONE_CM), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"deaths_per_hour"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"deaths_per_hour"), (Component)Component.translatable((String)"leaderboard.leaderboards.deaths_per_hour"), player -> {
            double dph = LeaderboardRegistry.getDPH(player);
            return Component.literal((String)(dph < 0.0 ? "-" : String.format("%.2f", dph)));
        }, Comparator.comparingDouble(LeaderboardRegistry::getDPH).reversed(), player -> LeaderboardRegistry.getDPH(player) >= 0.0));
        LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"last_seen"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"last_seen"), (Component)Component.translatable((String)"leaderboard.leaderboards.last_seen"), player -> {
            if (player.server.getPlayerList().getPlayer(player.getUUID()) != null) {
                return Component.translatable((String)"gui.online").withStyle(ChatFormatting.GREEN);
            }
            long lastSeen = PlayerDataTracker.getLastSeen(player.getUUID());
            if (lastSeen == 0L) {
                return Component.literal((String)"-");
            }
            long worldTime = player.server.overworld().getGameTime();
            int time = (int)(worldTime - lastSeen);
            return Leaderboard.FromStat.TIME.apply(time);
        }, Comparator.comparingLong(p -> {
            if (p.server.getPlayerList().getPlayer(p.getUUID()) != null) {
                return 0L;
            }
            return p.server.overworld().getGameTime() - PlayerDataTracker.getLastSeen(p.getUUID());
        }), player -> PlayerDataTracker.getLastSeen(player.getUUID()) != 0L || player.server.getPlayerList().getPlayer(player.getUUID()) != null));
        if (FTBQuestsIntegration.isAvailable()) {
            LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"quest_completions"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"quest_completions"), (Component)Component.translatable((String)"leaderboard.leaderboards.quest_completions"), player -> Component.literal((String)String.valueOf(FTBQuestsIntegration.getPlayerQuestCompletions(player))), Comparator.comparingInt(FTBQuestsIntegration::getPlayerQuestCompletions).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
            LEADERBOARDS.put(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"quest_completion_percentage"), new Leaderboard(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"quest_completion_percentage"), (Component)Component.translatable((String)"leaderboard.leaderboards.quest_completion_percentage"), player -> {
                double percentage = FTBQuestsIntegration.getQuestCompletionPercentage(player);
                return Component.literal((String)String.format("%.1f%%", percentage));
            }, Comparator.comparingDouble(FTBQuestsIntegration::getQuestCompletionPercentage).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
        }
        VanillaStatsRegistry.register();
    }

    private static double getDPH(PlayerStatsWrapper player) {
        double hours;
        int playTime = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
        if (playTime > 0 && (hours = (double)playTime / 72000.0) >= 1.0) {
            return (double)player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.DEATHS)) / hours;
        }
        return -1.0;
    }
}

