/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.LeaderboardRegistry;
import com.leclowndu93150.leaderboards.VanillaStatsRegistry;
import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.network.LeaderboardResponsePacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestLeaderboardPacket(ResourceLocation id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestLeaderboardPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"leaderboards", (String)"request_leaderboard"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestLeaderboardPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RequestLeaderboardPacket>(){

        public RequestLeaderboardPacket decode(RegistryFriendlyByteBuf buf) {
            return new RequestLeaderboardPacket(buf.readResourceLocation());
        }

        public void encode(RegistryFriendlyByteBuf buf, RequestLeaderboardPacket packet) {
            buf.writeResourceLocation(packet.id);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequestLeaderboardPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                Leaderboard leaderboard = LeaderboardRegistry.LEADERBOARDS.get(packet.id);
                if (leaderboard == null) {
                    leaderboard = VanillaStatsRegistry.VANILLA_STATS.get(packet.id);
                }
                if (leaderboard != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new LeaderboardResponsePacket(serverPlayer, leaderboard), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }
}

