/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.tileentities.TileCubeDispenser;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCubeDispenser
extends BaseChanceBlock
implements EntityBlock {
    public static final EnumProperty<DispenseType> DISPENSING = EnumProperty.create((String)"dispensing", DispenseType.class);

    public BlockCubeDispenser() {
        super(BlockCubeDispenser.getBuilder().strength(2.0f, 2.1474836E9f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(DISPENSING, (Comparable)((Object)DispenseType.CHANCE_CUBE)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileCubeDispenser(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TileCubeDispenser)) {
            return InteractionResult.PASS;
        }
        TileCubeDispenser te = (TileCubeDispenser)blockEntity;
        if (player.isCrouching()) {
            state = (BlockState)state.cycle(DISPENSING);
            level.setBlockAndUpdate(pos, state);
        } else {
            Block block = Block.byItem((Item)player.getInventory().getSelected().getItem());
            if (block.equals(te.getCurrentBlock(BlockCubeDispenser.getCurrentState(state)))) {
                player.getInventory().getSelected().shrink(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TileCubeDispenser)) {
            return;
        }
        TileCubeDispenser te = (TileCubeDispenser)blockEntity;
        ItemEntity entItem = te.getNewEntityItem(BlockCubeDispenser.getCurrentState(state));
        entItem.moveTo(player.getX(), player.getY(), player.getZ(), 0.0f, 0.0f);
        entItem.getItem().setCount(player.isCrouching() ? 1 : 64);
        level.addFreshEntity((Entity)entItem);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISPENSING});
    }

    public static DispenseType getCurrentState(BlockState state) {
        return (DispenseType)((Object)state.getValue(DISPENSING));
    }

    public static enum DispenseType implements StringRepresentable
    {
        CHANCE_CUBE("chance_cube"),
        CHANCE_ICOSAHEDRON("chance_icosahedron"),
        COMPACT_GIANTCUBE("compact_giant_cube");

        private final String type;

        private DispenseType(String name) {
            this.type = name;
        }

        public String getSerializedName() {
            return this.type;
        }
    }
}

