/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.items.CCubesItems;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.StatsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockGiantCube
extends BaseChanceBlock
implements EntityBlock {
    public BlockGiantCube() {
        super(BlockGiantCube.getBuilder());
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileGiantCube(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof TileGiantCube)) {
            return Shapes.block();
        }
        TileGiantCube gc = (TileGiantCube)te;
        BlockPos diff = gc.getMasterOffset();
        return Shapes.box((double)(diff.getX() - 1), (double)(diff.getY() - 1), (double)(diff.getZ() - 1), (double)(2 + diff.getX()), (double)(2 + diff.getY()), (double)(2 + diff.getZ()));
    }

    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockState destroyState = super.playerWillDestroy(level, pos, state, player);
        BlockEntity be = level.getBlockEntity(pos);
        if (!level.isClientSide() && be instanceof TileGiantCube) {
            TileGiantCube gcte = (TileGiantCube)be;
            if (!player.getInventory().getSelected().isEmpty() && player.getInventory().getSelected().getItem().equals(CCubesItems.SILK_PENDANT.get())) {
                BlockGiantCube.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CCubesBlocks.COMPACT_GIANT_CUBE.get()));
                GiantCubeUtil.removeStructure(gcte.getMasterPostion(), level);
                return destroyState;
            }
            if (!gcte.hasMaster() || !gcte.checkForMaster()) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
            ServerLevel serverWorld = (ServerLevel)level;
            RewardsUtil.executeCommand(serverWorld, player, (Vec3i)player.getOnPos(), "/advancement grant @p only chancecubes:giant_chance_cube");
            player.awardStat(StatsRegistry.OPENED_GIANT_CHANCE_CUBE.get());
            GlobalCCRewardRegistry.GIANT.triggerRandomReward(serverWorld, gcte.getMasterPostion(), player, 0);
            GiantCubeUtil.removeStructure(gcte.getMasterPostion(), level);
        }
        return destroyState;
    }
}

