/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.listeners;

import chanceCubes.util.SchematicUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class RenderEvent {
    private static boolean islookingAt = false;
    private static boolean creatingSchematic = false;
    private static int chance = -201;
    private static int chanceIncrease = 0;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGuiRender(RenderGuiLayerEvent.Post event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.TITLE)) {
            return;
        }
        int k = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int l = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        Font fontRenderer = Minecraft.getInstance().font;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack matrixStack = guiGraphics.pose();
        if (islookingAt) {
            matrixStack.pushPose();
            if (chance == -201) {
                guiGraphics.drawString(fontRenderer, "The chance of this cube is: Destruction... Probably", (float)k / 2.0f - 80.0f, (float)l / 2.0f - 30.0f, 0xFFFFFF, false);
            } else {
                guiGraphics.drawString(fontRenderer, "The chance of this cube is: " + chance, (float)k / 2.0f - 80.0f, (float)l / 2.0f - 30.0f, 0xFFFFFF, false);
                if (chanceIncrease != 0) {
                    int c = chance + chanceIncrease;
                    guiGraphics.drawString(fontRenderer, "Chance with pendants is: " + Math.min(100, Math.max(c, -100)), (float)k / 2.0f - 80.0f, (float)l / 2.0f - 15.0f, 0xFFFFFF, false);
                }
            }
            matrixStack.popPose();
        }
        if (creatingSchematic) {
            matrixStack.pushPose();
            String text1 = "--- Creating A Chance Cube Schematic ---";
            String text2 = "Right or left click a block or air to set positions.";
            String text3 = "/ChanceCubes schematic create to continue";
            String text4 = "/ChanceCubes schematic cancel to cancel";
            String text5 = "Point 1";
            String text6 = "Point 2";
            guiGraphics.drawString(fontRenderer, text1, (float)k / 2.0f - (float)fontRenderer.width(text1) / 2.0f, 10.0f, 0xFFFFFF, false);
            guiGraphics.drawString(fontRenderer, text2, (float)k / 2.0f - (float)fontRenderer.width(text2) / 2.0f, 20.0f, 0xFFFFFF, false);
            guiGraphics.drawString(fontRenderer, text3, (float)k / 2.0f - (float)fontRenderer.width(text3) / 2.0f, 30.0f, 0xFFFFFF, false);
            guiGraphics.drawString(fontRenderer, text4, (float)k / 2.0f - (float)fontRenderer.width(text4) / 2.0f, 40.0f, 0xFFFFFF, false);
            guiGraphics.drawString(fontRenderer, text5, (float)k / 2.0f - (float)fontRenderer.width(text5) / 2.0f, 60.0f, SchematicUtil.selectionPoints[0] == null ? 0xFF0000 : 65280, false);
            guiGraphics.drawString(fontRenderer, text6, (float)k / 2.0f - (float)fontRenderer.width(text6) / 2.0f, 70.0f, SchematicUtil.selectionPoints[1] == null ? 0xFF0000 : 65280, false);
            matrixStack.popPose();
        }
    }

    public static void setLookingAtChance(int c) {
        chance = c;
    }

    public static void setLookingAt(boolean lookingAt) {
        islookingAt = lookingAt;
    }

    public static void setChanceIncrease(int increase) {
        chanceIncrease = increase;
    }

    public static void setCreatingSchematic(boolean isCreating) {
        creatingSchematic = isCreating;
    }

    public static boolean isCreatingSchematic() {
        return creatingSchematic;
    }
}

