/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.renderer;

import chanceCubes.tileentities.TileGiantCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public class TileGiantCubeRenderer
implements BlockEntityRenderer<TileGiantCube> {
    private static final Map<Direction, ResourceLocation> GCC_TEXTURES = new HashMap<Direction, ResourceLocation>();

    public TileGiantCubeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileGiantCube tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int light, int overlayLight) {
        if (!tile.isMaster()) {
            return;
        }
        poseStack.pushPose();
        int lightToUse = light;
        if (tile.getLevel() != null) {
            lightToUse = tile.getLevel().getLightEmission(tile.getBlockPos().offset(0, 2, 0)) * 100;
        }
        for (Direction side : Direction.values()) {
            Material materialInterface = new Material(InventoryMenu.BLOCK_ATLAS, GCC_TEXTURES.get(side));
            VertexConsumer buffer = materialInterface.buffer(bufferIn, RenderType::text);
            poseStack.pushPose();
            poseStack.translate(-1.0f, -1.0f, -1.0f);
            poseStack.scale(0.1875f, -0.1875f, 0.1875f);
            float translateX = side.getStepX();
            float translateY = side.getStepY() - 1;
            float translateZ = side.getStepZ();
            int rotationY = 0;
            int rotationX = 0;
            switch (side) {
                case NORTH: {
                    translateZ += 1.0f;
                    translateX += 1.0f;
                    rotationY = 180;
                    break;
                }
                case EAST: {
                    translateZ += 1.0f;
                    rotationY = 90;
                    break;
                }
                case WEST: {
                    translateX += 1.0f;
                    rotationY = -90;
                    break;
                }
                case UP: {
                    translateZ += 1.0f;
                    rotationX = -90;
                    break;
                }
                case SOUTH: {
                    break;
                }
                case DOWN: {
                    rotationX = 90;
                    translateY += 1.0f;
                }
            }
            poseStack.translate(translateX * 16.0f, translateY * 16.0f, translateZ * 16.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)rotationY));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)rotationX));
            int r = 255;
            int g = 255;
            int b = 255;
            int a = 255;
            Matrix4f matrix = poseStack.last().pose();
            buffer.addVertex(matrix, 16.0f, 16.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(lightToUse);
            buffer.addVertex(matrix, 16.0f, 0.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(lightToUse);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setLight(lightToUse);
            buffer.addVertex(matrix, 0.0f, 16.0f, 0.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setLight(lightToUse);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(TileGiantCube tile) {
        return true;
    }

    static {
        GCC_TEXTURES.put(Direction.UP, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_1"));
        GCC_TEXTURES.put(Direction.NORTH, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_2"));
        GCC_TEXTURES.put(Direction.EAST, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_3"));
        GCC_TEXTURES.put(Direction.WEST, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_4"));
        GCC_TEXTURES.put(Direction.SOUTH, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_5"));
        GCC_TEXTURES.put(Direction.DOWN, ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"block/chance_cube_face_6"));
    }
}

