/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.BaseBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SnowGlobeBiome
extends BaseBiome {
    public SnowGlobeBiome(String name) {
        super(name);
    }

    @Override
    public void spawnEntities(final BlockPos pos, final ServerLevel level) {
        final Random rand = RewardsUtil.rand;
        for (int i = 0; i < rand.nextInt(10) + 5; ++i) {
            int ri = rand.nextInt(2);
            if (ri == 0) {
                SnowGolem snowman = (SnowGolem)EntityType.SNOW_GOLEM.create((Level)level);
                snowman.moveTo((double)(pos.getX() + (rand.nextInt(31) - 15)), (double)(pos.getY() + 1), (double)(pos.getZ() + (rand.nextInt(31) - 15)), 0.0f, 0.0f);
                level.addFreshEntity((Entity)snowman);
                continue;
            }
            PolarBear polarBear = (PolarBear)EntityType.POLAR_BEAR.create((Level)level);
            polarBear.moveTo((double)(pos.getX() + (rand.nextInt(31) - 15)), (double)(pos.getY() + 1), (double)(pos.getZ() + (rand.nextInt(31) - 15)), 0.0f, 0.0f);
            level.addFreshEntity((Entity)polarBear);
        }
        Scheduler.scheduleTask(new Task(this, "SnowGlobe Snow", 20){

            @Override
            public void callback() {
                for (int i = 0; i < 100; ++i) {
                    Snowball snowball = (Snowball)EntityType.SNOWBALL.create((Level)level);
                    snowball.setDeltaMovement(-1.0 + Math.random() * 2.0, 0.8, -1.0 + Math.random() * 2.0);
                    snowball.moveTo((double)(pos.getX() + (rand.nextInt(31) - 15)), (double)(pos.getY() + 1), (double)(pos.getZ() + (rand.nextInt(31) - 15)), 0.0f, 0.0f);
                    level.addFreshEntity((Entity)snowball);
                }
            }
        });
    }

    @Override
    public Block getFloorBlock() {
        return Blocks.SNOW_BLOCK;
    }

    @Override
    public void getRandomGenBlock(float dist, Random rand, int x, int y, int z, List<OffsetBlock> blocks, int delay) {
        if (y != 0) {
            return;
        }
        if (dist < 0.0f && rand.nextInt(5) == 0) {
            OffsetBlock osb = new OffsetBlock(x, y + 1, z, Blocks.SNOW, false, delay / 10);
            blocks.add(osb);
        }
    }
}

