/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MobTowerReward
extends BaseCustomReward {
    private final List<EntityType<? extends Entity>> entities = Arrays.asList(EntityType.CREEPER, EntityType.SKELETON, EntityType.BLAZE, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.ZOMBIFIED_PIGLIN, EntityType.SILVERFISH, EntityType.SLIME, EntityType.SNOW_GOLEM, EntityType.SPIDER, EntityType.WITCH, EntityType.ZOMBIE, EntityType.BAT, EntityType.CHICKEN, EntityType.COW, EntityType.OCELOT, EntityType.PARROT, EntityType.PIG, EntityType.RABBIT, EntityType.SHEEP, EntityType.VILLAGER, EntityType.WOLF, EntityType.PANDA, EntityType.PIGLIN, EntityType.BEE);

    public MobTowerReward() {
        super("chancecubes:mob_tower", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        Entity last;
        RewardsUtil.sendMessageToPlayer(player, "How did they end up like that? O.o");
        int minHeight = super.getSettingAsInt(settings, "minHeight", 7, 0, 20);
        int maxHeight = minHeight - super.getSettingAsInt(settings, "maxHeight", 13, 1, 50);
        if (maxHeight < 1) {
            maxHeight = 1;
        }
        if (minHeight > maxHeight) {
            int swap = minHeight;
            minHeight = maxHeight;
            maxHeight = swap;
        }
        int height = RewardsUtil.rand.nextInt(maxHeight) + minHeight;
        try {
            last = EntityWrapper.spawnEntityAt(this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())), (Level)level, pos);
        }
        catch (Exception e) {
            RewardsUtil.sendMessageToPlayer(player, "Uh oh! Something went wrong and the reward could not be spawned! Please report this to the mod dev!");
            return;
        }
        for (int i = 0; i < height; ++i) {
            try {
                Entity ent = EntityWrapper.spawnEntityAt(this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())), (Level)level, pos);
                ent.startRiding(last, true);
                last = ent;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

