/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.BlockWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class NonreplaceableBlockOverride {
    public BlockState overriddenBlock = Blocks.AIR.defaultBlockState();
    public OverrideType overrideType = OverrideType.ADD;

    public static List<NonreplaceableBlockOverride> parseStrings(String[] strings) {
        ArrayList<NonreplaceableBlockOverride> overrides = new ArrayList<NonreplaceableBlockOverride>();
        for (String string : strings) {
            NonreplaceableBlockOverride toAdd = NonreplaceableBlockOverride.parseString(string);
            if (toAdd == null) continue;
            overrides.add(toAdd);
        }
        return overrides;
    }

    @Nullable
    private static NonreplaceableBlockOverride parseString(@Nonnull String string) {
        try {
            switch (string.toCharArray()[0]) {
                case '+': {
                    return NonreplaceableBlockOverride.addBlock(string.substring(1));
                }
                case '-': {
                    return NonreplaceableBlockOverride.removeBlock(string.substring(1));
                }
                case '#': {
                    return null;
                }
            }
            return NonreplaceableBlockOverride.addBlock(string);
        }
        catch (Exception ex) {
            CCubesCore.logger.warn("Error adding block: " + ex.getMessage());
            CCubesCore.logger.warn("Could not add override for specified block \"" + string + "\", skipping.");
            return null;
        }
    }

    private static NonreplaceableBlockOverride removeBlock(String substring) {
        NonreplaceableBlockOverride output = new NonreplaceableBlockOverride();
        output.overrideType = OverrideType.REMOVE;
        output.overriddenBlock = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)substring))).defaultBlockState();
        return output;
    }

    private static NonreplaceableBlockOverride addBlock(String substring) {
        NonreplaceableBlockOverride output = new NonreplaceableBlockOverride();
        output.overrideType = OverrideType.ADD;
        output.overriddenBlock = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)substring))).defaultBlockState();
        return output;
    }

    public static String[] parseOverrides(List<NonreplaceableBlockOverride> overrides) {
        ArrayList<String> strings = new ArrayList<String>();
        for (NonreplaceableBlockOverride override : overrides) {
            String toAdd = NonreplaceableBlockOverride.parseOverride(override);
            if (toAdd == null) continue;
            strings.add(toAdd);
        }
        return strings.toArray(new String[0]);
    }

    @Nullable
    private static String parseOverride(@Nonnull NonreplaceableBlockOverride override) {
        switch (override.overrideType.ordinal()) {
            case 0: {
                return "+" + BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + Block.getId((BlockState)override.overriddenBlock);
            }
            case 1: {
                return "-" + BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + Block.getId((BlockState)override.overriddenBlock);
            }
        }
        CCubesCore.logger.error("I have no idea how this managed to fall through to the default...");
        return null;
    }

    public static void loadOverrides() {
        try {
            NonreplaceableBlockOverride.purgeOverrides();
            CCubesSettings.nonReplaceableBlocks = CCubesSettings.nonReplaceableBlocksIMC;
            block6: for (NonreplaceableBlockOverride override : CCubesSettings.nonReplaceableBlocksOverrides) {
                switch (override.overrideType.ordinal()) {
                    case 0: {
                        if (!CCubesSettings.nonReplaceableBlocks.contains(override.overriddenBlock)) {
                            CCubesSettings.nonReplaceableBlocks.add(override.overriddenBlock);
                            CCubesCore.logger.info("Adding " + BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + " to NRB array.");
                            continue block6;
                        }
                        CCubesCore.logger.info(BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + " already exists in the NRB array, skipping.");
                        continue block6;
                    }
                    case 1: {
                        if (CCubesSettings.nonReplaceableBlocks.contains(override.overriddenBlock)) {
                            CCubesSettings.nonReplaceableBlocks.remove(override.overriddenBlock);
                            CCubesCore.logger.info("Removing " + BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + " from NRB array.");
                            continue block6;
                        }
                        CCubesCore.logger.info(BlockWrapper.getBlockIdStr(override.overriddenBlock.getBlock()) + " has already been removed from the NRB array, skipping.");
                        continue block6;
                    }
                }
                CCubesCore.logger.error("Something has gone horribly awry, #BlameDaemonumbra!");
            }
        }
        catch (Exception ex) {
            CCubesCore.logger.warn("Whoops, something went wrong with loading the config, replacing NRB array with safety template...");
            CCubesSettings.nonReplaceableBlocks = CCubesSettings.nonReplaceableBlocksIMC;
            CCubesSettings.nonReplaceableBlocks.addAll(CCubesSettings.backupNRB);
        }
        CCubesSettings.nonReplaceableBlocks.add(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState());
        CCubesSettings.nonReplaceableBlocks.add(((BaseChanceBlock)((Object)CCubesBlocks.GIANT_CUBE.get())).defaultBlockState());
        CCubesSettings.nonReplaceableBlocks.add(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_ICOSAHEDRON.get())).defaultBlockState());
    }

    private static void purgeOverrides() {
        ArrayList<BlockState> blocksToRemove = new ArrayList<BlockState>();
        for (BlockState toRemove : CCubesSettings.nonReplaceableBlocks) {
            if (!NonreplaceableBlockOverride.noLongerExists(toRemove)) continue;
            blocksToRemove.add(toRemove);
            CCubesCore.logger.info("Removing " + BlockWrapper.getBlockIdStr(toRemove.getBlock()) + " from Overrides list.");
        }
        CCubesSettings.nonReplaceableBlocks.removeAll(blocksToRemove);
    }

    private static boolean noLongerExists(BlockState toDetect) {
        for (NonreplaceableBlockOverride override : CCubesSettings.nonReplaceableBlocksOverrides) {
            if (override.overriddenBlock != toDetect) continue;
            return false;
        }
        return true;
    }

    public static enum OverrideType {
        ADD,
        REMOVE,
        MODIFY;

    }
}

