/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.ConfigLoader;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.mcwrapper.JsonWrapper;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.FileUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SchematicUtil {
    private static final Gson gson = new GsonBuilder().create();
    public static final BlockPos[] selectionPoints = new BlockPos[2];

    public static void createCustomSchematic(final Level level, final BlockPos loc1, final BlockPos loc2, final String fileName) {
        Scheduler.scheduleTask(new Task("Schematic Creation", 1){

            @Override
            public void callback() {
                ArrayList<Integer> blocks = new ArrayList<Integer>();
                ArrayList<CustomEntry<Integer, String>> blockDataIds = new ArrayList<CustomEntry<Integer, String>>();
                ArrayList<CustomEntry<String, List<Integer>>> tileEntityData = new ArrayList<CustomEntry<String, List<Integer>>>();
                int largeX = Math.max(loc1.getX(), loc2.getX());
                int smallX = Math.min(loc1.getX(), loc2.getX());
                int largeY = Math.max(loc1.getY(), loc2.getY());
                int smallY = Math.min(loc1.getY(), loc2.getY());
                int largeZ = Math.max(loc1.getZ(), loc2.getZ());
                int smallZ = Math.min(loc1.getZ(), loc2.getZ());
                Vec3i small = new Vec3i(smallX, smallY, smallZ);
                Vec3i large = new Vec3i(largeX, largeY, largeZ);
                SchematicUtil.storeBlocksInfo(small, large, level, blocks, blockDataIds, tileEntityData);
                JsonObject json = new JsonObject();
                JsonArray blockArray = new JsonArray();
                int row = 0;
                int last = -1;
                Iterator iterator = blocks.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (last == i) {
                        ++row;
                        continue;
                    }
                    if (row != 0) {
                        Object value = "" + last;
                        if (row != 1) {
                            value = (String)value + "x" + row;
                        }
                        blockArray.add((JsonElement)new JsonPrimitive((String)value));
                    }
                    last = i;
                    row = 1;
                }
                String value = "" + last;
                if (row != 1) {
                    value = value + "x" + row;
                }
                blockArray.add((JsonElement)new JsonPrimitive(value));
                json.add("Blocks", (JsonElement)blockArray);
                JsonArray blockDataArray = new JsonArray();
                for (CustomEntry customEntry : blockDataIds) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty((String)customEntry.getValue(), (Number)customEntry.getKey());
                    blockDataArray.add((JsonElement)jsonObject);
                }
                json.add("Block Data", (JsonElement)blockDataArray);
                JsonArray tileEntityDataArray = new JsonArray();
                for (CustomEntry customEntry : tileEntityData) {
                    JsonObject index = new JsonObject();
                    JsonArray tileEntityBlockIds = new JsonArray();
                    Iterator iterator2 = ((List)customEntry.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        int id = (Integer)iterator2.next();
                        tileEntityBlockIds.add((JsonElement)new JsonPrimitive((Number)id));
                    }
                    index.add((String)customEntry.getKey(), (JsonElement)tileEntityBlockIds);
                    tileEntityDataArray.add((JsonElement)index);
                }
                json.add("TileEntities", (JsonElement)tileEntityDataArray);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("xSize", (Number)(large.getX() - small.getX()));
                jsonObject.addProperty("ySize", (Number)(large.getY() - small.getY()));
                jsonObject.addProperty("zSize", (Number)(large.getZ() - small.getZ()));
                json.add("Schematic Data", (JsonElement)jsonObject);
                FileUtil.writeToFile(ConfigLoader.schematicsFolder.getAbsolutePath() + "/" + fileName, gson.toJson((JsonElement)json));
            }
        });
    }

    private static void storeBlocksInfo(Vec3i small, Vec3i large, Level level, List<Integer> blocks, List<CustomEntry<Integer, String>> blockDataIds, List<CustomEntry<String, List<Integer>>> tileEntityData) {
        StringBuilder blockData = new StringBuilder();
        for (int y = small.getY(); y < large.getY(); ++y) {
            for (int x = small.getX(); x < large.getX(); ++x) {
                for (int z = small.getZ(); z < large.getZ(); ++z) {
                    BlockEntity te;
                    blockData.setLength(0);
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState blockState = level.getBlockState(pos);
                    blockData.append(BlockWrapper.getBlockId(blockState.getBlock()));
                    String encoded = SchematicUtil.encodeBlockState(blockState);
                    if (!encoded.isEmpty()) {
                        blockData.append(":").append(encoded);
                    }
                    String blockString = blockData.toString();
                    int id = -1;
                    for (CustomEntry<Integer, String> data : blockDataIds) {
                        if (!blockString.equalsIgnoreCase(data.getValue())) continue;
                        id = data.getKey();
                    }
                    if (id == -1) {
                        id = blockDataIds.size();
                        blockDataIds.add(new CustomEntry<Integer, String>(id, blockString));
                    }
                    blocks.add(id);
                    if (level.getBlockEntity(pos) == null || (te = level.getBlockEntity(pos)) == null) continue;
                    CompoundTag nbt = te.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                    for (CustomEntry<String, List<Integer>> data : tileEntityData) {
                        if (!nbt.toString().equalsIgnoreCase(data.getKey())) continue;
                        data.getValue().add(blocks.size() - 1);
                        break;
                    }
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(blocks.size() - 1);
                    tileEntityData.add(new CustomEntry(nbt.toString(), list));
                }
            }
        }
    }

    public static CustomSchematic loadCustomSchematic(String file, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        JsonElement elem = FileUtil.readJsonFromFile(ConfigLoader.schematicsFolder.getAbsolutePath() + "/" + file);
        return SchematicUtil.loadCustomSchematic(elem, xOffSet, yOffSet, zOffSet, spacingDelay, falling, relativeToPlayer, includeAirBlocks, playSound, delay);
    }

    public static CustomSchematic loadCustomSchematic(JsonElement elem, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        if (elem == null) {
            return null;
        }
        JsonObject json = elem.getAsJsonObject();
        ArrayList<OffsetBlock> offsetBlocks = new ArrayList<OffsetBlock>();
        JsonObject info = json.get("Schematic Data").getAsJsonObject();
        int xSize = info.get("xSize").getAsInt();
        int ySize = info.get("ySize").getAsInt();
        int zSize = info.get("zSize").getAsInt();
        ArrayList<CustomEntry<Integer, String>> blockDataIds = new ArrayList<CustomEntry<Integer, String>>();
        JsonArray blockDataArray = json.get("Block Data").getAsJsonArray();
        for (JsonElement i : blockDataArray) {
            JsonObject index = i.getAsJsonObject();
            for (Map.Entry obj : index.entrySet()) {
                blockDataIds.add(new CustomEntry<Integer, String>(((JsonElement)obj.getValue()).getAsInt(), (String)obj.getKey()));
            }
        }
        int index = 0;
        ArrayList<Integer> blockArray = new ArrayList<Integer>();
        for (JsonElement ids : json.get("Blocks").getAsJsonArray()) {
            String entry = ids.getAsString();
            String[] parts = entry.split("x");
            int id = Integer.parseInt(parts[0]);
            int recurse = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            for (int i = 0; i < recurse; ++i) {
                blockArray.add(id);
            }
        }
        for (int yOff = 0; yOff < ySize; ++yOff) {
            for (int xOff = xSize / 2 - xSize; xOff < xSize / 2; ++xOff) {
                for (int zOff = zSize / 2 - zSize; zOff < zSize / 2; ++zOff) {
                    String[] stringArray;
                    int id = (Integer)blockArray.get(index);
                    String blockData = "";
                    for (CustomEntry customEntry : blockDataIds) {
                        if ((Integer)customEntry.getKey() != id) continue;
                        blockData = (String)customEntry.getValue();
                        break;
                    }
                    BlockState state = (stringArray = blockData.split(":")).length == 1 ? ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)stringArray[0]))).defaultBlockState() : ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)stringArray[0], (String)stringArray[1]))).defaultBlockState();
                    if (stringArray.length == 3) {
                        state = SchematicUtil.decodeBlockState(state, stringArray[2]);
                    }
                    OffsetBlock osb = new OffsetBlock(xOff + xOffSet, yOff + yOffSet, zOff + zOffSet, state.getBlock(), falling, new IntVar(0));
                    osb.setBlockState(state);
                    osb.setRelativeToPlayer(relativeToPlayer);
                    osb.setPlaysSound(playSound);
                    offsetBlocks.add(osb);
                    ++index;
                }
            }
        }
        JsonArray teArray = json.get("TileEntities").getAsJsonArray();
        for (JsonElement i : teArray) {
            for (Map.Entry obj : i.getAsJsonObject().entrySet()) {
                String teData = (String)obj.getKey();
                for (JsonElement ids : ((JsonElement)obj.getValue()).getAsJsonArray()) {
                    int id = ids.getAsInt();
                    OffsetBlock osb = (OffsetBlock)offsetBlocks.get(id);
                    OffsetTileEntity oste = SchematicUtil.OffsetBlockToTileEntity(osb, teData);
                    offsetBlocks.set(id, oste);
                }
            }
        }
        return new CustomSchematic(offsetBlocks, xSize, ySize, zSize, relativeToPlayer, includeAirBlocks, spacingDelay, delay);
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, String nbt) {
        return SchematicUtil.OffsetBlockToTileEntity(osb, JsonWrapper.getNBTFromJson(nbt));
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, NBTVar nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), nbt, osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, CompoundTag nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), new NBTVar(nbt), osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static JsonElement getSchematicJson(String path) {
        BufferedReader in = new BufferedReader(new InputStreamReader(SchematicUtil.class.getResourceAsStream(path)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JsonParser.parseString((String)builder.toString());
    }

    public static String encodeBlockState(BlockState state) {
        StringBuilder builder = new StringBuilder("[");
        for (Property prop : state.getProperties()) {
            if (!state.hasProperty(prop)) continue;
            builder.append(prop.getName()).append("=").append(state.getValue(prop)).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public static BlockState decodeBlockState(BlockState defaultState, String stateString) {
        BlockState returnState = defaultState;
        if (!stateString.matches("\\[.*]")) {
            return returnState;
        }
        stateString = stateString.substring(1, stateString.length() - 1);
        HashMap map = new HashMap();
        Arrays.stream(stateString.split(",")).forEach(s -> {
            String[] entry = s.split("=");
            map.put(entry[0], entry[1]);
        });
        for (Property prop : defaultState.getProperties()) {
            if (!map.containsKey(prop.getName())) continue;
            returnState = SchematicUtil.withString(returnState, prop, (String)map.get(prop.getName()));
        }
        return returnState;
    }

    public static <T extends Comparable<T>> BlockState withString(BlockState state, Property<T> prop, String propVal) {
        return prop.getValue(propVal).map(t -> (BlockState)state.setValue(prop, t)).orElse(state);
    }
}

