/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.init.FDBlockEntities;
import com.finderfeed.fdlib.init.FDEntities;
import com.finderfeed.fdlib.init.FDParticles;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityRendererBuilder;
import com.finderfeed.fdlib.systems.post_shaders.FDPostShadersReloadableResourceListener;
import com.finderfeed.fdlib.systems.shapes.FD2DShape;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.NullEntityRenderer;
import com.finderfeed.fdlib.util.client.particles.FDTerrainParticle;
import com.finderfeed.fdlib.util.client.particles.InvisibleParticle;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticle;
import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticle;
import com.finderfeed.fdlib.util.rendering.renderers.ShapeOnCurveRenderer;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(modid="fdlib", value={Dist.CLIENT})
public class FDClientModEvents {
    public static final String FDLIB_KEY_CATEGORY = "fdlib.key_category";
    public static final KeyMapping END_CUTSCENE = new KeyMapping("fdlib.key.end_cutscene", InputConstants.Type.KEYSYM, 74, "fdlib.key_category");

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(END_CUTSCENE);
    }

    @SubscribeEvent
    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new FDPostShadersReloadableResourceListener());
    }

    @SubscribeEvent
    public static void assignFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FDParticles.INVISIBLE.get(), InvisibleParticle.Factory::new);
        event.registerSpriteSet(FDParticles.BALL_PARTICLE.get(), BallParticle.Factory::new);
        event.registerSpecial(FDParticles.LIGHTNING_PARTICLE.get(), (ParticleProvider)new LightningParticle.Factory());
        event.registerSpecial(FDParticles.TERRAIN_PARTICLE.get(), (ParticleProvider)new FDTerrainParticle.Provider());
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(FDEntities.CLIENT_CAMERA.get(), NullEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerBERenderers(FMLClientSetupEvent event) {
        BlockEntityRenderers.register(FDBlockEntities.TEST.get(), FDBlockEntityRendererBuilder.builder().freeRender((blockEntity, pticks, matrices, src, light, overlay) -> {
            VertexConsumer vertexConsumer = src.getBuffer(RenderType.lightning());
            FD2DShape shape = FD2DShape.createSimpleCircleNVertexShape(1.0f, 4);
            float time = (float)blockEntity.getLevel().getGameTime() + pticks;
            float percent = (float)Math.sin(time / 50.0f) / 2.0f + 0.5f;
            float percent2 = (float)Math.sin(time / 50.0f - 0.3926991f) / 2.0f + 0.5f;
            ShapeOnCurveRenderer.start(vertexConsumer).uModifier(10.0f).vModifier(2.0f).shape(shape).lod(100).startColor(new FDColor(1.0f, 0.0f, 0.0f, 0.25f)).endColor(new FDColor(0.0f, 1.0f, 0.0f, 0.25f)).curvePositions(new Vector3f(10.0f, 10.0f, 0.0f), new Vector3f(0.0f, 3.0f, 3.0f), new Vector3f(10.1f, -2.0f, 0.0f), new Vector3f(10.0f, -1.0f, 5.0f), new Vector3f(0.0f, 2.0f, 10.0f), new Vector3f(-0.001f, 1.0E-4f, 1.0E-4f)).pose(matrices).trailScalingFunction().render();
        }).build());
    }

    private static Vector3f rotatePoint(Quaternionf quaternionf, Vector3f point) {
        return quaternionf.transform((Vector3fc)point, new Vector3f());
    }
}

