/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.AnimatedItemTickListener;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="fdlib")
public class FDItemAnimationHandler {
    private static final HashMap<ItemStack, AnimatedItem> ANIMATED_ITEMS = new HashMap();

    @SubscribeEvent
    public static void tickItems(ClientTickEvent.Pre event) {
        FDItemAnimationHandler.tickAnimatedItems();
    }

    public static FDItemAnimationSystem getItemAnimationSystem(ItemStack itemStack) {
        if (ANIMATED_ITEMS.containsKey(itemStack)) {
            AnimatedItem animatedItem = ANIMATED_ITEMS.get(itemStack);
            return animatedItem.animationSystem;
        }
        return null;
    }

    public static void tickAnimatedItems() {
        Iterator<Map.Entry<ItemStack, AnimatedItem>> iterator = ANIMATED_ITEMS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemStack, AnimatedItem> item = iterator.next();
            AnimatedItem animatedItem = item.getValue();
            animatedItem.tick();
            if (!animatedItem.shouldBeRemoved()) continue;
            iterator.remove();
        }
    }

    public static void tellItemThatItIsAlive(ItemStack itemStack) {
        if (ANIMATED_ITEMS.containsKey(itemStack)) {
            AnimatedItem item = ANIMATED_ITEMS.get(itemStack);
            item.tellThatIAmAlive();
        } else {
            ANIMATED_ITEMS.put(itemStack, new AnimatedItem(itemStack));
        }
    }

    private static class AnimatedItem {
        public FDItemAnimationSystem animationSystem;
        public ItemStack itemStack;
        public int age;

        public AnimatedItem(ItemStack itemStack) {
            this.itemStack = itemStack;
            this.animationSystem = new FDItemAnimationSystem();
        }

        public void tick() {
            Item item = this.itemStack.getItem();
            if (item instanceof AnimatedItemTickListener) {
                AnimatedItemTickListener animatedItemTickListener = (AnimatedItemTickListener)item;
                animatedItemTickListener.animatedItemTick(this.itemStack);
            }
            this.animationSystem.tick();
            ++this.age;
        }

        public boolean shouldBeRemoved() {
            return this.age > 400 || this.itemStack.isEmpty();
        }

        public void tellThatIAmAlive() {
            this.age = 0;
        }
    }
}

