/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes.camera_motion;

import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.data_structures.ObjectHolder;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneUtil;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import com.finderfeed.fdlib.systems.cutscenes.camera_motion.CameraLookProcessor;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.List;

public class NormalLookProcessor
extends CameraLookProcessor {
    @Override
    public void rotate(CutsceneData cutsceneData, int currentTime, float partialTick, ObjectHolder<Float> yaw, ObjectHolder<Float> pitch, ObjectHolder<Float> roll) {
        List<CameraPos> positions = cutsceneData.getCameraPositions();
        EasingType timeEasing = cutsceneData.getTimeEasing();
        EasingType easingType = cutsceneData.getLookEasing();
        float p = timeEasing.apply(CutsceneUtil.getPercent(cutsceneData, currentTime, partialTick));
        float globalPercent = p * (float)(positions.size() - 1);
        int index = (int)globalPercent;
        float localPercent = easingType.apply(globalPercent - (float)index);
        CameraPos current = FDLibCalls.getListValueOrBoundaries(index, positions);
        CameraPos next = FDLibCalls.getListValueOrBoundaries(index + 1, positions);
        float currentYaw = current.getYaw();
        float nextYaw = next.getYaw();
        float currentPitch = current.getPitch();
        float nextPitch = next.getPitch();
        float currentRoll = current.getRoll();
        float nextRoll = next.getRoll();
        float pitchValue = FDMathUtil.lerp(currentPitch, nextPitch, localPercent);
        float yawValue = FDMathUtil.lerpAround(currentYaw, nextYaw, -180.0f, 180.0f, localPercent);
        float rollValue = FDMathUtil.lerp(currentRoll, nextRoll, localPercent);
        pitch.setValue(Float.valueOf(pitchValue));
        yaw.setValue(Float.valueOf(yawValue));
        roll.setValue(Float.valueOf(rollValue));
    }
}

