/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.hud.bossbars;

import com.finderfeed.fdlib.systems.hud.bossbars.FDBossBar;
import com.finderfeed.fdlib.systems.hud.bossbars.FDBossbars;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.BossHealthOverlay;

public class FDBossBarsOverlay
implements LayeredDraw.Layer {
    public static final float BASE_BOSS_BAR_TOP_OFFSET = 3.0f;

    public void render(GuiGraphics graphics, DeltaTracker deltraTracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        float pticks = deltraTracker.getGameTimeDeltaPartialTick(false);
        PoseStack matrices = graphics.pose();
        Window window = Minecraft.getInstance().getWindow();
        float width = window.getGuiScaledWidth();
        matrices.pushPose();
        float baseOffset = FDBossBarsOverlay.calculateBossBarsOffset();
        matrices.translate(width / 2.0f, baseOffset, 0.0f);
        for (FDBossBar bossBar : FDBossbars.BOSS_BARS.values()) {
            float height = bossBar.height();
            bossBar.render(graphics, pticks);
            matrices.translate(0.0f, height, 0.0f);
        }
        matrices.popPose();
    }

    public static float calculateBossBarsOffset() {
        BossHealthOverlay bossOverlay = Minecraft.getInstance().gui.getBossOverlay();
        int size = bossOverlay.events.size();
        return 3.0f + (float)(size * 25);
    }
}

