/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_entries;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.TextBlockCursor;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.TextBlockEntry;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.TextBlockWidget;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.interactions.InteractionBox;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.interactions.TextBlockEntryInteraction;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class SimpleTextEntry
implements TextBlockEntry {
    private FormattedText component;
    private float textScale;
    private TextBlockEntryInteraction interaction;
    private Style styleOverride;
    private boolean renderShadow;
    private int textColor;

    public SimpleTextEntry(FormattedText component, float textScale, boolean renderShadow, int textColor, TextBlockEntryInteraction interaction) {
        this.component = component;
        this.textScale = textScale;
        this.renderShadow = renderShadow;
        this.interaction = interaction;
        this.textColor = textColor;
    }

    public SimpleTextEntry(FormattedText component, float textScale, boolean renderShadow, int textColor) {
        this(component, textScale, renderShadow, textColor, TextBlockEntryInteraction.empty());
    }

    public SimpleTextEntry chatFormattingOverride(Style chatFormatting) {
        this.styleOverride = chatFormatting;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, TextBlockWidget textBlock, TextBlockCursor cursor, float mx, float my, float pticks, boolean last) {
        if (this.component.getString().isEmpty()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * this.textScale;
        int remainingWidth = (int)cursor.remainingWidth(textBlock.getBorderX());
        if (remainingWidth > 0) {
            Pair<FormattedText, FormattedText> texts = SimpleTextEntry.splitOneTime(this.component, Math.round((float)remainingWidth / this.textScale));
            FormattedText first = (FormattedText)texts.first;
            if (this.styleOverride != null) {
                first = FormattedText.of((String)first.getString(), (Style)this.styleOverride);
            }
            FDRenderUtil.renderScaledText(graphics, Language.getInstance().getVisualOrder(first), cursor.x, cursor.y, this.textScale, this.renderShadow, this.textColor);
            float width = (float)font.width(first) * this.textScale;
            textBlock.addInteractionBox(new InteractionBox(cursor.x, cursor.y, width, lineHeight, this.interaction));
            cursor.addX(width);
            if (texts.second != null) {
                FormattedText second = (FormattedText)texts.second;
                if (this.styleOverride != null) {
                    second = FormattedText.of((String)second.getString(), (Style)this.styleOverride);
                }
                Objects.requireNonNull(font);
                cursor.nextLine(9.0f * this.textScale);
                this.renderNormalText(second, graphics, textBlock, cursor, this.textScale, last);
            } else if (last) {
                cursor.nextLine(lineHeight);
            }
        } else {
            Objects.requireNonNull(font);
            cursor.nextLine(9.0f * this.textScale);
            this.renderNormalText(this.component, graphics, textBlock, cursor, this.textScale, last);
        }
    }

    private void renderNormalText(FormattedText text, GuiGraphics graphics, TextBlockWidget textBlock, TextBlockCursor cursor, float scale, boolean last) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * this.textScale;
        StringSplitter splitter = font.getSplitter();
        List sequences = splitter.splitLines(text, Math.round(textBlock.getWidth() / scale), Style.EMPTY);
        if (sequences.isEmpty()) {
            return;
        }
        for (FormattedText formattedText : sequences) {
            if (this.styleOverride != null) {
                formattedText = FormattedText.of((String)formattedText.getString(), (Style)this.styleOverride);
            }
            FDRenderUtil.renderScaledText(graphics, Language.getInstance().getVisualOrder(formattedText), cursor.x, cursor.y, this.textScale, this.renderShadow, this.textColor);
            textBlock.addInteractionBox(new InteractionBox(cursor.x, cursor.y, (float)font.width(formattedText) * this.textScale, lineHeight, this.interaction));
            cursor.nextLine(lineHeight);
        }
        if (!last) {
            cursor.nextLine(-lineHeight);
        }
        cursor.addX((float)font.width((FormattedText)sequences.getLast()) * scale - 3.0f * scale);
    }

    public static Pair<FormattedText, FormattedText> splitOneTime(FormattedText text, int pixels) {
        String str;
        StringSplitter splitter = Minecraft.getInstance().font.getSplitter();
        int lineBreak = splitter.findLineBreak(str = text.getString(), pixels, Style.EMPTY);
        if (lineBreak >= str.length()) {
            return new Pair<FormattedText, Object>(text, null);
        }
        ArrayList styleString = new ArrayList();
        text.visit((string, style) -> {
            styleString.add(new Pair<Style, String>(string, style));
            return Optional.empty();
        }, Style.EMPTY);
        int currentIndex = 0;
        FormattedText before = FormattedText.EMPTY;
        FormattedText after = FormattedText.EMPTY;
        boolean wasSplit = false;
        boolean shouldDeleteSpace = false;
        for (Pair pair : styleString) {
            Style style2 = (Style)pair.first;
            String s = (String)pair.second;
            int stringLength = s.length();
            if (wasSplit) {
                if (shouldDeleteSpace) {
                    if (s.charAt(0) == ' ' || s.charAt(0) == '\n') {
                        s = s.substring(1);
                    }
                    shouldDeleteSpace = false;
                }
                after = FormattedText.composite((FormattedText[])new FormattedText[]{after, FormattedText.of((String)s, (Style)style2)});
                continue;
            }
            if (stringLength + currentIndex < lineBreak) {
                currentIndex += stringLength;
                before = FormattedText.composite((FormattedText[])new FormattedText[]{before, FormattedText.of((String)s, (Style)style2)});
                continue;
            }
            int substrlength = lineBreak - currentIndex;
            String first = s.substring(0, substrlength);
            String second = s.substring(substrlength);
            before = FormattedText.composite((FormattedText[])new FormattedText[]{before, FormattedText.of((String)first, (Style)style2)});
            if (!second.isEmpty()) {
                if (second.charAt(0) == ' ' || second.charAt(0) == '\n') {
                    second = second.substring(1);
                }
                after = FormattedText.composite((FormattedText[])new FormattedText[]{after, FormattedText.of((String)second, (Style)style2)});
            } else {
                shouldDeleteSpace = true;
            }
            wasSplit = true;
        }
        return new Pair<FormattedText, FormattedText>(before, after);
    }
}

